/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPrel
extends DrillProjectRelBase
implements Prel {
    static final Logger logger = LoggerFactory.getLogger(ProjectPrel.class);
    protected final boolean outputProj;

    public ProjectPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType) {
        this(cluster, traits, child, exps, rowType, false);
    }

    public ProjectPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType, boolean outputProj) {
        super(DRILL_PHYSICAL, cluster, traits, child, exps, rowType);
        this.outputProj = outputProj;
    }

    public org.apache.calcite.rel.core.Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        return new ProjectPrel(this.getCluster(), traitSet, input, exps, rowType, this.outputProj);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        Project p = new Project(this.getProjectExpressions(new DrillParseContext(PrelUtil.getSettings(this.getCluster()))), childPOP, this.outputProj);
        return creator.addMetadata(this, p);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitProject(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        for (RexNode expr : this.exps) {
            if (expr.getKind() != SqlKind.OTHER_FUNCTION || !(expr instanceof RexCall) || !((RexCall)expr).getOperator().getName().equalsIgnoreCase("CONVERT_FROMJSON")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        RexBuilder builder = this.getCluster().getRexBuilder();
        ArrayList<RexNode> projects = Lists.newArrayList();
        projects.add((RexNode)builder.makeInputRef(typeFactory.createSqlType(SqlTypeName.INTEGER), 0));
        projects.addAll(DrillRelOptUtil.transformExprs(builder, this.getProjects(), DrillRelOptUtil.rightShiftColsInRowType(this.getInput().getRowType())));
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
        fieldNames.add("$drill_implicit_field$");
        fieldTypes.add(typeFactory.createSqlType(SqlTypeName.INTEGER));
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            fieldNames.add(field.getName());
            fieldTypes.add(field.getType());
        }
        RelDataType newRowType = typeFactory.createStructType(fieldTypes, fieldNames);
        return (Prel)this.copy(this.getTraitSet(), children.get(0), projects, newRowType);
    }
}

