/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ProjectPrule
extends Prule {
    public static final RelOptRule INSTANCE = new ProjectPrule();

    private ProjectPrule() {
        super(RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "ProjectPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        Map<Integer, Integer> collationMap;
        DrillProjectRel project = (DrillProjectRel)call.rel(0);
        RelNode input = project.getInput();
        RelTraitSet traits = input.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelNode convertedInput = ProjectPrule.convert(input, traits);
        Map<Integer, Integer> distributionMap = this.getDistributionMap(project);
        boolean traitPull = new ProjectTraitPull(call, distributionMap, collationMap = this.getCollationMap(project)).go(project, convertedInput);
        if (!traitPull) {
            call.transformTo((RelNode)new ProjectPrel(project.getCluster(), convertedInput.getTraitSet(), convertedInput, project.getProjects(), project.getRowType()));
        }
    }

    private DrillDistributionTrait convertDist(DrillDistributionTrait srcDist, Map<Integer, Integer> inToOut) {
        ArrayList<DrillDistributionTrait.DistributionField> newFields = Lists.newArrayList();
        for (DrillDistributionTrait.DistributionField field : srcDist.getFields()) {
            if (!inToOut.containsKey(field.getFieldId())) continue;
            newFields.add(new DrillDistributionTrait.DistributionField(inToOut.get(field.getFieldId())));
        }
        if (newFields.isEmpty() || newFields.size() < srcDist.getFields().size()) {
            if (srcDist.getType() != DrillDistributionTrait.DistributionType.SINGLETON) {
                return DrillDistributionTrait.RANDOM_DISTRIBUTED;
            }
            return DrillDistributionTrait.SINGLETON;
        }
        return new DrillDistributionTrait(srcDist.getType(), ImmutableList.copyOf(newFields));
    }

    private RelCollation convertRelCollation(RelCollation src, Map<Integer, Integer> inToOut) {
        ArrayList<RelFieldCollation> newFields = Lists.newArrayList();
        for (RelFieldCollation field : src.getFieldCollations()) {
            if (!inToOut.containsKey(field.getFieldIndex())) continue;
            newFields.add(new RelFieldCollation(inToOut.get(field.getFieldIndex()).intValue(), field.getDirection(), field.nullDirection));
        }
        if (newFields.isEmpty()) {
            return RelCollations.of((RelFieldCollation[])new RelFieldCollation[0]);
        }
        return RelCollations.of(newFields);
    }

    private Map<Integer, Integer> getDistributionMap(DrillProjectRel project) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Ord node : Ord.zip((List)project.getProjects())) {
            RexNode operand;
            if (node.e instanceof RexInputRef) {
                m.put(((RexInputRef)node.e).getIndex(), node.i);
                continue;
            }
            if (!((RexNode)node.e).isA(SqlKind.CAST) || !((operand = (RexNode)((RexCall)node.e).getOperands().get(0)) instanceof RexInputRef)) continue;
            m.put(((RexInputRef)operand).getIndex(), node.i);
        }
        return m;
    }

    private Map<Integer, Integer> getCollationMap(DrillProjectRel project) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Ord node : Ord.zip((List)project.getProjects())) {
            if (!(node.e instanceof RexInputRef)) continue;
            m.put(((RexInputRef)node.e).getIndex(), node.i);
        }
        return m;
    }

    private class ProjectTraitPull
    extends SubsetTransformer<DrillProjectRel, RuntimeException> {
        final Map<Integer, Integer> distributionMap;
        final Map<Integer, Integer> collationMap;

        public ProjectTraitPull(RelOptRuleCall call, Map<Integer, Integer> distributionMap, Map<Integer, Integer> collationMap) {
            super(call);
            this.distributionMap = distributionMap;
            this.collationMap = collationMap;
        }

        @Override
        public RelNode convertChild(DrillProjectRel project, RelNode rel) throws RuntimeException {
            DrillDistributionTrait childDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
            RelCollation childCollation = (RelCollation)rel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
            DrillDistributionTrait newDist = ProjectPrule.this.convertDist(childDist, this.distributionMap);
            RelCollation newCollation = ProjectPrule.this.convertRelCollation(childCollation, this.collationMap);
            RelTraitSet newProjectTraits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, newDist, newCollation});
            return new ProjectPrel(project.getCluster(), newProjectTraits, rel, project.getProjects(), project.getRowType());
        }
    }
}

