/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.RangePartitionExchange;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PartitionFunction;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class RangePartitionExchangePrel
extends ExchangePrel {
    private final List<DrillDistributionTrait.DistributionField> fields;
    private final PartitionFunction partitionFunction;

    public RangePartitionExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<DrillDistributionTrait.DistributionField> fields, PartitionFunction partitionFunction) {
        super(cluster, traitSet, input);
        this.fields = fields;
        this.partitionFunction = partitionFunction;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq == null ? -1.0 : mq.getRowCount(child);
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, 0.0, 0.0, 0.0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new RangePartitionExchangePrel(this.getCluster(), traitSet, (RelNode)RangePartitionExchangePrel.sole(inputs), this.fields, this.partitionFunction);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        RangePartitionExchange g = new RangePartitionExchange(childPOP, this.partitionFunction);
        return creator.addMetadata(this, g);
    }

    public List<DrillDistributionTrait.DistributionField> getFields() {
        return this.fields;
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.fields)) {
            pw.item("dist" + ord.i, ord.e);
        }
        return pw;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }
}

