/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.RowKeyJoinPOP;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class RowKeyJoinPrel
extends JoinPrel
implements Prel {
    double estimatedRowCount = -1.0;

    public RowKeyJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, joinType);
        Preconditions.checkArgument(joinType == JoinRelType.INNER);
    }

    public RowKeyJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean isSemiJoin) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, isSemiJoin);
        Preconditions.checkArgument(joinType == JoinRelType.INNER);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        PhysicalOperator leftPop = ((Prel)this.left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)this.right).getPhysicalOperator(creator);
        RowKeyJoinPOP rkPop = new RowKeyJoinPOP(leftPop, rightPop);
        return creator.addMetadata(this, rkPop);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        if (this.estimatedRowCount >= 0.0) {
            return this.estimatedRowCount;
        }
        return this.getLeft().estimateRowCount(mq);
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            RowKeyJoinPrel rkj = new RowKeyJoinPrel(this.getCluster(), traitSet, left, right, conditionExpr, joinType, this.isSemiJoin());
            rkj.setEstimatedRowCount(this.estimatedRowCount);
            return rkj;
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        double rowCount = mq.getRowCount(this.getRight());
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCount, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getLeft(), this.getRight());
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    public void setEstimatedRowCount(double rowCount) {
        this.estimatedRowCount = rowCount;
    }
}

