/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.physical.HasDistributionAffinity;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanPrel
extends DrillScanRelBase
implements LeafPrel,
HasDistributionAffinity {
    private static final Logger logger = LoggerFactory.getLogger(ScanPrel.class);
    private final RelDataType rowType;

    public ScanPrel(RelOptCluster cluster, RelTraitSet traits, GroupScan groupScan, RelDataType rowType, RelOptTable table) {
        super(cluster, traits, ScanPrel.getCopy(groupScan), table);
        this.rowType = rowType;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ScanPrel(this.getCluster(), traitSet, this.getGroupScan(), this.rowType, this.getTable());
    }

    @Override
    public ScanPrel copy(RelTraitSet traitSet, GroupScan scan, RelDataType rowType) {
        return new ScanPrel(this.getCluster(), traitSet, scan, rowType, this.getTable());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ScanPrel(this.getCluster(), this.getTraitSet(), ScanPrel.getCopy(this.getGroupScan()), this.rowType, this.getTable());
    }

    private static GroupScan getCopy(GroupScan scan) {
        try {
            return (GroupScan)scan.getNewWithChildren(Collections.emptyList());
        }
        catch (ExecutionSetupException e) {
            throw new DrillRuntimeException("Unexpected failure while coping node.", e);
        }
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        return creator.addMetadata(this, this.getGroupScan());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupscan", (Object)this.getGroupScan().getDigest());
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(this.getCluster());
        double rowCount = this.getGroupScan().getScanStats(settings).getRecordCount();
        logger.debug("#{}.estimateRowCount get rowCount {} from  groupscan {}", new Object[]{this.getId(), rowCount, System.identityHashCode(this.getGroupScan())});
        return rowCount;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(planner);
        ScanStats stats = this.getGroupScan().getScanStats(settings);
        int columnCount = this.getRowType().getFieldCount();
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return planner.getCostFactory().makeCost(stats.getRecordCount() * (double)columnCount, stats.getCpuCost(), stats.getDiskCost());
        }
        double rowCount = mq.getRowCount((RelNode)this);
        double cpuCost = rowCount * (double)Math.max(columnCount, 1);
        if (stats.getCpuCost() > 0.0) {
            cpuCost *= stats.getCpuCost();
        }
        double ioCost = stats.getDiskCost();
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCount, cpuCost, ioCost, 0.0);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitScan(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public DistributionAffinity getDistributionAffinity() {
        return this.getGroupScan().getDistributionAffinity();
    }
}

