/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.AggPruleBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashToMergeExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.StreamAggPrel;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class StreamAggPrule
extends AggPruleBase {
    public static final RelOptRule INSTANCE = new StreamAggPrule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private StreamAggPrule() {
        super(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "StreamAggPrule");
    }

    public boolean matches(RelOptRuleCall call) {
        return PrelUtil.getPlannerSettings(call.getPlanner()).isStreamAggEnabled();
    }

    public void onMatch(RelOptRuleCall call) {
        final DrillAggregateRel aggregate = (DrillAggregateRel)call.rel(0);
        RelNode input = aggregate.getInput();
        final RelCollation collation = this.getCollation(aggregate);
        if (aggregate.containsDistinctCall()) {
            return;
        }
        try {
            if (aggregate.getGroupSet().isEmpty()) {
                DrillDistributionTrait singleDist = DrillDistributionTrait.SINGLETON;
                final RelTraitSet singleDistTrait = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)singleDist);
                if (this.create2PhasePlan(call, aggregate)) {
                    RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = StreamAggPrule.convert(input, traits);
                    new SubsetTransformer<DrillAggregateRel, InvalidRelException>(call){

                        @Override
                        public RelNode convertChild(DrillAggregateRel join, RelNode rel) throws InvalidRelException {
                            DrillDistributionTrait toDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
                            RelTraitSet traits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, toDist});
                            RelNode newInput = Prule.convert(rel, traits);
                            StreamAggPrel phase1Agg = new StreamAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
                            UnionExchangePrel exch = new UnionExchangePrel(phase1Agg.getCluster(), singleDistTrait, phase1Agg);
                            ImmutableBitSet newGroupSet = AggPruleBase.remapGroupSet(aggregate.getGroupSet());
                            ArrayList<ImmutableBitSet> newGroupSets = Lists.newArrayList();
                            for (ImmutableBitSet groupSet : aggregate.getGroupSets()) {
                                newGroupSets.add(AggPruleBase.remapGroupSet(groupSet));
                            }
                            return new StreamAggPrel(aggregate.getCluster(), singleDistTrait, exch, newGroupSet, newGroupSets, phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
                        }
                    }.go(aggregate, convertedInput);
                } else {
                    this.createTransformRequest(call, aggregate, input, singleDistTrait);
                }
            } else {
                final DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, true)));
                RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation).plus((RelTrait)distOnAllKeys);
                this.createTransformRequest(call, aggregate, input, traits);
                DrillDistributionTrait distOnOneKey = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, false)));
                traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation).plus((RelTrait)distOnOneKey);
                if (this.create2PhasePlan(call, aggregate)) {
                    traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = StreamAggPrule.convert(input, traits);
                    new SubsetTransformer<DrillAggregateRel, InvalidRelException>(call){

                        @Override
                        public RelNode convertChild(DrillAggregateRel aggregate, RelNode rel) throws InvalidRelException {
                            DrillDistributionTrait toDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
                            RelTraitSet traits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, collation, toDist});
                            RelNode newInput = Prule.convert(rel, traits);
                            StreamAggPrel phase1Agg = new StreamAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
                            int numEndPoints = PrelUtil.getSettings(phase1Agg.getCluster()).numEndPoints();
                            HashToMergeExchangePrel exch = new HashToMergeExchangePrel(phase1Agg.getCluster(), phase1Agg.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distOnAllKeys), phase1Agg, ImmutableList.copyOf(StreamAggPrule.this.getDistributionField(aggregate, true)), collation, numEndPoints);
                            ImmutableBitSet newGroupSet = AggPruleBase.remapGroupSet(aggregate.getGroupSet());
                            ArrayList<ImmutableBitSet> newGroupSets = Lists.newArrayList();
                            for (ImmutableBitSet groupSet : aggregate.getGroupSets()) {
                                newGroupSets.add(AggPruleBase.remapGroupSet(groupSet));
                            }
                            return new StreamAggPrel(aggregate.getCluster(), exch.getTraitSet(), exch, newGroupSet, newGroupSets, phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
                        }
                    }.go(aggregate, convertedInput);
                }
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }

    private void createTransformRequest(RelOptRuleCall call, DrillAggregateRel aggregate, RelNode input, RelTraitSet traits) throws InvalidRelException {
        RelNode convertedInput = StreamAggPrule.convert(input, traits);
        StreamAggPrel newAgg = new StreamAggPrel(aggregate.getCluster(), traits, convertedInput, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of1);
        call.transformTo((RelNode)newAgg);
    }

    private RelCollation getCollation(DrillAggregateRel rel) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        Iterator iterator = BitSets.toIter((ImmutableBitSet)rel.getGroupSet()).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            fields.add(new RelFieldCollation(group));
        }
        return RelCollations.of(fields);
    }
}

