/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubsetTransformer<T extends RelNode, E extends Exception> {
    private static final Logger logger = LoggerFactory.getLogger(SubsetTransformer.class);
    private final RelOptRuleCall call;

    public SubsetTransformer(RelOptRuleCall call) {
        this.call = call;
    }

    public abstract RelNode convertChild(T var1, RelNode var2) throws E;

    public boolean forceConvert() {
        return false;
    }

    public RelTraitSet newTraitSet(RelTrait ... traits) {
        RelTraitSet set = this.call.getPlanner().emptyTraitSet();
        for (RelTrait t : traits) {
            set = set.plus(t);
        }
        return set;
    }

    public boolean go(T n, RelNode candidateSet) throws E {
        if (!(candidateSet instanceof RelSubset)) {
            return false;
        }
        boolean transform = false;
        Set<RelNode> transformedRels = Sets.newIdentityHashSet();
        HashSet<RelTraitSet> traitSets = Sets.newHashSet();
        for (RelNode rel : ((RelSubset)candidateSet).getRelList()) {
            RelTraitSet relTraitSet;
            if (!this.isPhysical(rel) || traitSets.contains(relTraitSet = rel.getTraitSet())) continue;
            traitSets.add(relTraitSet);
            logger.trace("{}.convertChild get traitSet {}", (Object)this.getClass().getSimpleName(), (Object)relTraitSet);
        }
        if (traitSets.size() == 0 && this.forceConvert()) {
            RelNode out = this.convertChild(n, null);
            if (out != null) {
                this.call.transformTo(out);
                return true;
            }
            return false;
        }
        for (RelTraitSet traitSet : traitSets) {
            RelNode newRel = RelOptRule.convert((RelNode)candidateSet, (RelTraitSet)traitSet.simplify());
            if (transformedRels.contains(newRel)) continue;
            transformedRels.add(newRel);
            logger.trace("{}.convertChild to convert NODE {} ,AND {}", new Object[]{this.getClass().getSimpleName(), n, newRel});
            RelNode out = this.convertChild(n, newRel);
            if (out == null) continue;
            this.call.transformTo(out);
            transform = true;
        }
        return transform;
    }

    private boolean isPhysical(RelNode n) {
        return ((Convention)n.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE)).equals(Prel.DRILL_PHYSICAL);
    }
}

