/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.planner.logical.ModifyTableEntry;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.record.BatchSchema;
import org.jetbrains.annotations.NotNull;

public class TableModifyPrel
extends TableModify
implements Prel {
    protected TableModifyPrel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new TableModifyPrel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), inputs.get(0), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        List tablePath = this.getTable().getQualifiedName();
        List<String> schemaPath = tablePath.size() > 1 ? tablePath.subList(0, tablePath.size() - 1) : Collections.emptyList();
        String tableName = (String)tablePath.get(tablePath.size() - 1);
        SchemaPlus schema = ((CalciteCatalogReader)this.getTable().getRelOptSchema()).getRootSchema().plus();
        ModifyTableEntry modifyTableEntry = SchemaUtilities.resolveToDrillSchema(schema, schemaPath).modifyTable(tableName);
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        Writer p = modifyTableEntry.getWriter(childPOP);
        return creator.addMetadata(this, p);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitTableModify(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    @Override
    @NotNull
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount((RelNode)this);
        double inputRowCount = mq.getRowCount(this.getInput());
        double dIo = inputRowCount + 1.0;
        return planner.getCostFactory().makeCost(rowCount, 0.0, dIo).multiplyBy(10.0);
    }
}

