/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.UnnestPOP;
import org.apache.drill.exec.planner.common.DrillUnnestRelBase;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;

public class UnnestPrel
extends DrillUnnestRelBase
implements LeafPrel {
    protected final UnnestPOP unnestPOP;

    public UnnestPrel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, RexNode ref) {
        super(cluster, traits, ref);
        this.unnestPOP = new UnnestPOP(null, SchemaPath.getSimplePath(((RexFieldAccess)ref).getField().getName()), "$drill_implicit_field$");
        this.rowType = rowType;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> visitor, X value) throws E {
        return visitor.visitUnnest(this, value);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        return creator.addMetadata(this, this.unnestPOP);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    public Class<?> getParentClass() {
        return LateralJoinPrel.class;
    }

    public RelNode accept(RexShuttle shuttle) {
        RexNode ref = shuttle.apply(this.ref);
        if (this.ref == ref) {
            return this;
        }
        return new UnnestPrel(this.getCluster(), this.traitSet, this.rowType, ref);
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
        fieldNames.add("$drill_implicit_field$");
        fieldTypes.add(typeFactory.createSqlType(SqlTypeName.INTEGER));
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            fieldNames.add(field.getName());
            fieldTypes.add(field.getType());
        }
        RelDataType newRowType = typeFactory.createStructType(fieldTypes, fieldNames);
        return new UnnestPrel(this.getCluster(), this.getTraitSet(), newRowType, this.ref);
    }
}

