/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.planner.common.DrillWindowRelBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class WindowPrel
extends DrillWindowRelBase
implements Prel {
    public WindowPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, Window.Group window) {
        super(cluster, traits, child, constants, rowType, Collections.singletonList(window));
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        RelDataType copiedRowType = this.deriveCopiedRowTypeFromInput((RelNode)WindowPrel.sole(inputs));
        return new WindowPrel(this.getCluster(), traitSet, (RelNode)WindowPrel.sole(inputs), (List<RexLiteral>)this.constants, copiedRowType, (Window.Group)this.groups.get(0));
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        List childFields = this.getInput().getRowType().getFieldNames();
        Preconditions.checkState(this.groups.size() == 1, "Only one window is expected in WindowPrel");
        Window.Group window = (Window.Group)this.groups.get(0);
        ArrayList<NamedExpression> withins = Lists.newArrayList();
        ArrayList<NamedExpression> aggs = Lists.newArrayList();
        ArrayList<Order.Ordering> orderings = Lists.newArrayList();
        Iterator<Object> iterator = BitSets.toIter((ImmutableBitSet)window.keys).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            FieldReference fr = new FieldReference((CharSequence)childFields.get(group), ExpressionPosition.UNKNOWN);
            withins.add(new NamedExpression(fr, fr));
        }
        for (AggregateCall aggCall : window.getAggregateCalls((Window)this)) {
            FieldReference ref = new FieldReference(aggCall.getName());
            LogicalExpression expr = this.toDrill(aggCall, childFields);
            aggs.add(new NamedExpression(expr, ref));
        }
        for (RelFieldCollation fieldCollation : window.orderKeys.getFieldCollations()) {
            orderings.add(new Order.Ordering(fieldCollation.getDirection(), (LogicalExpression)new FieldReference((CharSequence)childFields.get(fieldCollation.getFieldIndex())), fieldCollation.nullDirection));
        }
        WindowPOP windowPOP = new WindowPOP(childPOP, withins, aggs, orderings, window.isRows, WindowPOP.newBound(window.lowerBound), WindowPOP.newBound(window.upperBound));
        creator.addMetadata(this, windowPOP);
        return windowPOP;
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn) {
        DrillParseContext context = new DrillParseContext(PrelUtil.getSettings(this.getCluster()));
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            int indexInConstants = i - fn.size();
            if (i < fn.size()) {
                args.add(new FieldReference(fn.get(i)));
                continue;
            }
            RexLiteral constant = (RexLiteral)this.constants.get(indexInConstants);
            LogicalExpression expr = DrillOptiq.toDrill(context, this.getInput(), (RexNode)constant);
            args.add(expr);
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        return new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    private RelDataType deriveCopiedRowTypeFromInput(RelNode input) {
        RelDataType inputRowType = input.getRowType();
        RelDataType windowRowType = this.getRowType();
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>(inputRowType.getFieldList());
        int inputFieldCount = inputRowType.getFieldCount();
        int windowFieldCount = windowRowType.getFieldCount();
        for (int i = inputFieldCount; i < windowFieldCount; ++i) {
            fieldList.add((RelDataTypeField)windowRowType.getFieldList().get(i));
        }
        RelDataType rowType = this.getCluster().getRexBuilder().getTypeFactory().createStructType(fieldList);
        return rowType;
    }
}

