/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillWindowRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.WindowPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Predicate;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class WindowPrule
extends Prule {
    public static final RelOptRule INSTANCE = new WindowPrule();

    private WindowPrule() {
        super(RelOptHelper.some(DrillWindowRel.class, (RelTrait)DrillRel.DRILL_LOGICAL, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "Prel.WindowPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        DrillWindowRel window = (DrillWindowRel)call.rel(0);
        RelNode input = call.rel(1);
        boolean partitionby = false;
        boolean addMerge = false;
        int startConstantsIndex = window.getInput().getRowType().getFieldCount();
        int constantShiftIndex = 0;
        for (final Ord w : Ord.zip((List)window.groups)) {
            Window.Group windowBase = (Window.Group)w.getValue();
            RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
            if (windowBase.keys.isEmpty() && windowBase.orderKeys.getFieldCollations().isEmpty()) {
                DrillDistributionTrait distEmptyKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.SINGLETON);
                traits = traits.plus((RelTrait)distEmptyKeys);
            } else if (windowBase.keys.size() > 0) {
                DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionFields(windowBase)));
                partitionby = true;
                traits = traits.plus((RelTrait)distOnAllKeys);
            } else if (windowBase.orderKeys.getFieldCollations().size() > 0) {
                DrillDistributionTrait distKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionFieldsFromCollation(windowBase)));
                traits = traits.plus((RelTrait)distKeys);
                if (!WindowPrule.isSingleMode(call)) {
                    addMerge = true;
                }
            }
            if (partitionby || windowBase.orderKeys.getFieldCollations().size() > 0) {
                RelCollation collation = this.getCollation(windowBase);
                traits = traits.plus((RelTrait)collation);
            }
            RelNode convertedInput = WindowPrule.convert(input, traits);
            if (addMerge) {
                traits = traits.plus((RelTrait)DrillDistributionTrait.SINGLETON);
                convertedInput = new SingleMergeExchangePrel(window.getCluster(), traits, convertedInput, windowBase.collation());
            }
            ArrayList<RelDataTypeField> newRowFields = Lists.newArrayList();
            newRowFields.addAll(convertedInput.getRowType().getFieldList());
            Iterable<RelDataTypeField> newWindowFields = Iterables.filter(window.getRowType().getFieldList(), new Predicate<RelDataTypeField>(){

                @Override
                public boolean apply(RelDataTypeField relDataTypeField) {
                    return relDataTypeField.getName().startsWith("w" + w.i + "$");
                }
            });
            for (RelDataTypeField newField : newWindowFields) {
                newRowFields.add(newField);
            }
            RelRecordType rowType = new RelRecordType(newRowFields);
            ArrayList<Window.RexWinAggCall> newWinAggCalls = Lists.newArrayList();
            for (Ord aggOrd : Ord.zip((List)windowBase.aggCalls)) {
                Window.RexWinAggCall aggCall = (Window.RexWinAggCall)aggOrd.getValue();
                ArrayList<RexNode> newOperandsOfWindowFunction = Lists.newArrayList();
                for (RexNode operand : aggCall.getOperands()) {
                    if (operand instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)operand;
                        int refIndex = rexInputRef.getIndex();
                        if (rexInputRef.getIndex() >= startConstantsIndex) {
                            operand = new RexInputRef(refIndex + constantShiftIndex, ((RexLiteral)window.constants.get(refIndex - startConstantsIndex)).getType());
                        }
                    }
                    newOperandsOfWindowFunction.add(operand);
                }
                aggCall = new Window.RexWinAggCall((SqlAggFunction)aggCall.getOperator(), aggCall.getType(), newOperandsOfWindowFunction, aggCall.ordinal, aggCall.distinct);
                newWinAggCalls.add(new Window.RexWinAggCall((SqlAggFunction)aggCall.getOperator(), aggCall.getType(), aggCall.getOperands(), aggOrd.i, aggCall.distinct));
            }
            windowBase = new Window.Group(windowBase.keys, windowBase.isRows, windowBase.lowerBound, windowBase.upperBound, windowBase.orderKeys, newWinAggCalls);
            input = new WindowPrel(window.getCluster(), window.getTraitSet().merge(traits), convertedInput, (List<RexLiteral>)window.getConstants(), (RelDataType)rowType, windowBase);
            constantShiftIndex += windowBase.aggCalls.size();
        }
        call.transformTo(input);
    }

    private RelCollation getCollation(Window.Group window) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        Iterator iterator = BitSets.toIter((ImmutableBitSet)window.keys).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            fields.add(new RelFieldCollation(group));
        }
        fields.addAll(window.orderKeys.getFieldCollations());
        return RelCollations.of(fields);
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionFields(Window.Group window) {
        ArrayList<DrillDistributionTrait.DistributionField> groupByFields = Lists.newArrayList();
        Iterator iterator = BitSets.toIter((ImmutableBitSet)window.keys).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(group);
            groupByFields.add(field);
        }
        return groupByFields;
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionFieldsFromCollation(Window.Group window) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (RelFieldCollation relField : window.collation().getFieldCollations()) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(relField.getFieldIndex());
            distFields.add(field);
        }
        return distFields;
    }
}

