/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.planner.common.DrillWriterRelBase;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillWriterRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class WriterPrule
extends Prule {
    public static final RelOptRule INSTANCE = new WriterPrule();

    public WriterPrule() {
        super(RelOptHelper.some(DrillWriterRel.class, (RelTrait)DrillRel.DRILL_LOGICAL, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "Prel.WriterPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        DrillWriterRel writer = (DrillWriterRel)call.rel(0);
        RelNode input = call.rel(1);
        List<Integer> keys = writer.getPartitionKeys();
        RelCollation collation = this.getCollation(keys);
        boolean hashDistribute = PrelUtil.getPlannerSettings(call.getPlanner()).getOptions().getOption(ExecConstants.CTAS_PARTITIONING_HASH_DISTRIBUTE_VALIDATOR);
        RelTraitSet traits = hashDistribute ? input.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation).plus((RelTrait)this.getDistribution(keys)) : input.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation);
        RelNode convertedInput = WriterPrule.convert(input, traits);
        if (!new WriteTraitPull(call).go(writer, convertedInput)) {
            WriterPrel newWriter = new WriterPrel(writer.getCluster(), convertedInput.getTraitSet(), convertedInput, writer.getCreateTableEntry());
            call.transformTo((RelNode)newWriter);
        }
    }

    private RelCollation getCollation(List<Integer> keys) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        for (int key : keys) {
            fields.add(new RelFieldCollation(key));
        }
        return RelCollations.of(fields);
    }

    private DrillDistributionTrait getDistribution(List<Integer> keys) {
        ArrayList<DrillDistributionTrait.DistributionField> fields = Lists.newArrayList();
        for (int key : keys) {
            fields.add(new DrillDistributionTrait.DistributionField(key));
        }
        return new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(fields));
    }

    private class WriteTraitPull
    extends SubsetTransformer<DrillWriterRelBase, RuntimeException> {
        public WriteTraitPull(RelOptRuleCall call) {
            super(call);
        }

        @Override
        public RelNode convertChild(DrillWriterRelBase writer, RelNode rel) throws RuntimeException {
            DrillDistributionTrait childDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
            return new WriterPrel(writer.getCluster(), writer.getTraitSet().plus((RelTrait)childDist).plus((RelTrait)Prel.DRILL_PHYSICAL), rel, writer.getCreateTableEntry());
        }
    }
}

