/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.explain;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.NumberingRelWriter;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class PrelSequencer
extends BasePrelVisitor<Void, Frag, RuntimeException> {
    private List<Frag> frags = Lists.newLinkedList();

    public static String printWithIds(Prel rel, SqlExplainLevel explainlevel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        NumberingRelWriter planWriter = new NumberingRelWriter(PrelSequencer.getIdMap(rel), new PrintWriter(sw), explainlevel);
        rel.explain(planWriter);
        return sw.toString();
    }

    public static Map<Prel, OpId> getIdMap(Prel rel) {
        PrelSequencer s = new PrelSequencer();
        return s.go(rel);
    }

    public Map<Prel, OpId> go(Prel root) {
        Frag rootFrag = new Frag(root);
        this.frags.add(rootFrag);
        root.accept(this, rootFrag);
        LinkedList<Frag> q = Lists.newLinkedList();
        q.add(rootFrag);
        int majorFragmentId = 0;
        while (!q.isEmpty()) {
            Frag frag = (Frag)q.remove();
            frag.majorFragmentId = majorFragmentId++;
            for (Frag child : frag) {
                q.add(child);
            }
        }
        IdentityHashMap<Prel, OpId> ids = Maps.newIdentityHashMap();
        ids.put(rootFrag.root, new OpId(0, 0));
        for (Frag f : this.frags) {
            int id = 1;
            LinkedList<Prel> ops = Lists.newLinkedList();
            ops.add(f.root);
            while (!ops.isEmpty()) {
                Prel p = (Prel)ops.remove();
                boolean isExchange = p instanceof ExchangePrel;
                if (p != f.root) {
                    ids.put(p, new OpId(f.majorFragmentId, id++));
                }
                if (isExchange && p != f.root) continue;
                List<Prel> children = Lists.reverse(Lists.newArrayList(p.iterator()));
                for (Prel child : children) {
                    ops.add(child);
                }
            }
        }
        return ids;
    }

    @Override
    public Void visitExchange(ExchangePrel prel, Frag value) throws RuntimeException {
        Frag newFrag = new Frag(prel);
        this.frags.add(newFrag);
        value.children.add(newFrag);
        for (Prel child : prel) {
            child.accept(this, newFrag);
        }
        return null;
    }

    @Override
    public Void visitPrel(Prel prel, Frag value) throws RuntimeException {
        for (Prel children : prel) {
            children.accept(this, value);
        }
        return null;
    }

    static class Frag
    implements Iterable<Frag> {
        Prel root;
        int majorFragmentId;
        final List<Frag> children = Lists.newArrayList();

        public Frag(Prel root) {
            this.root = root;
        }

        @Override
        public Iterator<Frag> iterator() {
            return this.children.iterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
            result = 31 * result + this.majorFragmentId;
            result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Frag other = (Frag)obj;
            if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
                return false;
            }
            if (this.majorFragmentId != other.majorFragmentId) {
                return false;
            }
            return !(this.root == null ? other.root != null : !this.root.equals(other.root));
        }

        public String toString() {
            int maxLen = 10;
            return "Frag [root=" + this.root + ", majorFragmentId=" + this.majorFragmentId + ", children=" + (this.children != null ? this.children.subList(0, Math.min(this.children.size(), 10)) : null) + "]";
        }
    }

    public static class OpId {
        int fragmentId;
        int opId;

        public OpId(int fragmentId, int opId) {
            this.fragmentId = fragmentId;
            this.opId = opId;
        }

        public int getFragmentId() {
            return this.fragmentId;
        }

        public int getOpId() {
            return this.opId;
        }

        public int getAsSingleInt() {
            return (this.fragmentId << 16) + this.opId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fragmentId;
            result = 31 * result + this.opId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpId other = (OpId)obj;
            if (this.fragmentId != other.fragmentId) {
                return false;
            }
            return this.opId == other.opId;
        }

        public String toString() {
            return this.fragmentId + ":*:" + this.opId;
        }
    }
}

