/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.server.options.OptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryEstimationVisitor
extends BasePrelVisitor<Double, Void, RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(MemoryEstimationVisitor.class);

    public static boolean enoughMemory(Prel prel, OptionManager options, int numDrillbits) {
        long allottedMemory = options.getOption((String)"planner.memory.max_query_memory_per_node").num_val * (long)numDrillbits;
        long estimatedMemory = (long)Math.ceil(prel.accept(new MemoryEstimationVisitor(), null) / 1048576.0);
        if ((estimatedMemory += options.getOption((String)"planner.memory.non_blocking_operators_memory").num_val * (long)numDrillbits) > allottedMemory) {
            logger.debug("Estimated memory (" + estimatedMemory + ") exceeds maximum allowed (" + allottedMemory + ")");
        } else {
            logger.debug("Estimated memory (" + estimatedMemory + ") within maximum allowed (" + allottedMemory + ")");
        }
        return estimatedMemory <= allottedMemory;
    }

    public static Double estimateMemory(Prel prel) {
        return prel.accept(new MemoryEstimationVisitor(), null);
    }

    @Override
    public Double visitPrel(Prel prel, Void value) throws RuntimeException {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        return ((DrillCostBase)mq.getCumulativeCost((RelNode)prel)).getMemory();
    }

    private double findCost(Prel prel, RelMetadataQuery mq) {
        DrillCostBase cost = (DrillCostBase)mq.getNonCumulativeCost((RelNode)prel);
        double memory = cost.getMemory();
        for (Prel child : prel) {
            memory += this.findCost(child, mq);
        }
        return memory;
    }
}

