/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import org.apache.drill.exec.planner.physical.DirectScanPrel;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.TableModifyPrel;
import org.apache.drill.exec.planner.physical.UnnestPrel;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;

public class PrelVisualizerVisitor
implements PrelVisitor<Void, VisualizationState, Exception> {
    public static void print(String label, Prel prel) {
        System.out.println(label);
        System.out.println(PrelVisualizerVisitor.visualize(prel));
    }

    public static String visualize(Prel prel) {
        try {
            VisualizationState state = new VisualizationState();
            prel.accept(new PrelVisualizerVisitor(), state);
            return state.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "** ERROR **";
        }
    }

    @Override
    public Void visitExchange(ExchangePrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    private void visitBasePrel(Prel prel, VisualizationState value) {
        value.startNode(prel);
        value.visitField("encodings", (Object[])prel.getSupportedEncodings());
        value.visitField("needsReorder", prel.needsFinalColumnReordering());
    }

    private void endNode(Prel prel, VisualizationState value) throws Exception {
        value.endFields();
        this.visitChildren(prel, value);
        value.endNode();
    }

    private void visitChildren(Prel prel, VisualizationState value) throws Exception {
        value.indent();
        value.out.append("children = [\n");
        value.push();
        for (Prel child : prel) {
            child.accept(this, value);
        }
        value.pop();
        value.indent();
        value.out.append("]\n");
    }

    @Override
    public Void visitScreen(ScreenPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitWriter(WriterPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitScan(ScanPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitScan(DirectScanPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitJoin(JoinPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitProject(ProjectPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitPrel(Prel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    @Override
    public Void visitUnnest(UnnestPrel prel, VisualizationState value) throws Exception {
        this.visitPrel((Prel)prel, value);
        return null;
    }

    @Override
    public Void visitLateral(LateralJoinPrel prel, VisualizationState value) throws Exception {
        this.visitPrel((Prel)prel, value);
        return null;
    }

    @Override
    public Void visitLeaf(LeafPrel prel, VisualizationState value) throws Exception {
        this.visitPrel((Prel)prel, value);
        return null;
    }

    @Override
    public Void visitTableModify(TableModifyPrel prel, VisualizationState value) throws Exception {
        this.visitBasePrel(prel, value);
        this.endNode(prel, value);
        return null;
    }

    public static class VisualizationState {
        public static String INDENT = "  ";
        StringBuilder out = new StringBuilder();
        int level;

        public void startNode(Prel prel) {
            this.indent();
            this.out.append("{ ");
            this.out.append(prel.getClass().getSimpleName());
            this.out.append("\n");
            this.push();
        }

        public void endNode() {
            this.pop();
            this.indent();
            this.out.append("}");
            this.out.append("\n");
        }

        private void indent() {
            for (int i = 0; i < this.level; ++i) {
                this.out.append(INDENT);
            }
        }

        public void push() {
            ++this.level;
        }

        public void pop() {
            --this.level;
        }

        public void endFields() {
        }

        public void visitField(String label, boolean value) {
            this.visitField(label, Boolean.toString(value));
        }

        private void visitField(String label, String value) {
            this.indent();
            this.out.append(label).append(" = ").append(value).append("\n");
        }

        public void visitField(String label, Object[] values) {
            if (values == null) {
                this.visitField(label, "null");
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            boolean first = true;
            for (Object obj : values) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                if (obj == null) {
                    buf.append("null");
                    continue;
                }
                buf.append(obj.toString());
            }
            buf.append("]");
            this.visitField(label, buf.toString());
        }

        public String toString() {
            return this.out.toString();
        }
    }
}

