/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProducerConsumerPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ProducerConsumerPrelVisitor
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    private int queueSize;

    public static Prel addProducerConsumerToScans(Prel prel, int queueSize) {
        return prel.accept(new ProducerConsumerPrelVisitor(queueSize), null);
    }

    public ProducerConsumerPrelVisitor(int queueSize) {
        this.queueSize = queueSize;
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            children.add(child.accept(this, null));
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitScan(ScanPrel scanPrel, Void value) {
        return new ProducerConsumerPrel(scanPrel, this.queueSize);
    }
}

