/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Set;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelUniqifier
extends BasePrelVisitor<Prel, Set<Prel>, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(RelUniqifier.class);
    private static final RelUniqifier INSTANCE = new RelUniqifier();

    public static Prel uniqifyGraph(Prel p) {
        Set data = Sets.newIdentityHashSet();
        return p.accept(INSTANCE, data);
    }

    @Override
    public Prel visitPrel(Prel prel, Set<Prel> data) throws RuntimeException {
        ArrayList<Prel> children = Lists.newArrayList();
        boolean childrenChanged = false;
        for (Prel child : prel) {
            Prel newChild = this.visitPrel(child, data);
            if (newChild != child) {
                childrenChanged = true;
            }
            children.add(newChild);
        }
        if (data.contains(prel) || childrenChanged) {
            return (Prel)prel.copy(prel.getTraitSet(), children);
        }
        return prel;
    }
}

