/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelConversionException;
import org.apache.drill.exec.planner.physical.FlattenPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RewriteProjectToFlatten
extends BasePrelVisitor<Prel, Object, RelConversionException> {
    RelDataTypeFactory factory;
    DrillOperatorTable table;

    public RewriteProjectToFlatten(RelDataTypeFactory factory, DrillOperatorTable table) {
        this.factory = factory;
        this.table = table;
    }

    @Override
    public Prel visitPrel(Prel prel, Object value) throws RelConversionException {
        ArrayList<Prel> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(child);
        }
        if (children.equals(prel.getInputs())) {
            return prel;
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitProject(ProjectPrel project, Object unused) throws RelConversionException {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        boolean rewrite = false;
        ArrayList<RelDataTypeField> relDataTypes = new ArrayList<RelDataTypeField>();
        int i = 0;
        RexInputRef flatttenExpr = null;
        Iterator iterator = project.getProjects().iterator();
        while (iterator.hasNext()) {
            RexCall function;
            String functionName;
            RexNode rex;
            RexNode newExpr = rex = (RexNode)iterator.next();
            if (rex instanceof RexCall && (functionName = (function = (RexCall)rex).getOperator().getName()).equalsIgnoreCase("flatten")) {
                rewrite = true;
                if (function.getOperands().size() != 1) {
                    throw new RelConversionException("Flatten expression expects a single input.");
                }
                newExpr = (RexNode)function.getOperands().get(0);
                RexBuilder builder = new RexBuilder(this.factory);
                flatttenExpr = builder.makeInputRef((RelDataType)new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), i);
            }
            relDataTypes.add((RelDataTypeField)project.getRowType().getFieldList().get(i));
            ++i;
            exprList.add(newExpr);
        }
        if (rewrite) {
            Prel newChild = ((Prel)project.getInput(0)).accept(this, null);
            ProjectPrel newProject = new ProjectPrel(project.getCluster(), project.getTraitSet(), newChild, exprList, (RelDataType)new RelRecordType(relDataTypes));
            FlattenPrel flatten = new FlattenPrel(project.getCluster(), project.getTraitSet(), newProject, (RexNode)flatttenExpr);
            return flatten;
        }
        Prel child = ((Prel)project.getInput()).accept(this, null);
        if (child == project.getInput() && exprList.equals(project.getProjects())) {
            return project;
        }
        return (Prel)project.copy(project.getTraitSet(), child, exprList, (RelDataType)new RelRecordType(relDataTypes));
    }
}

