/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlAggFunctionWrapper;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlBetweenOperatorWrapper;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlFunctionWrapper;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlOperatorWrapper;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlSumEmptyIsZeroAggFunctionWrapper;
import org.apache.drill.exec.planner.sql.DrillCalciteSqlWrapper;
import org.apache.drill.exec.planner.sql.DrillSqlAggOperator;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class DrillOperatorTable
extends SqlStdOperatorTable {
    private static final SqlOperatorTable inner = SqlStdOperatorTable.instance();
    private final List<SqlOperator> calciteOperators = Lists.newArrayList();
    private final List<SqlOperator> drillOperatorsWithoutInference = Lists.newArrayList();
    private final List<SqlOperator> drillOperatorsWithInference = Lists.newArrayList();
    private final Map<SqlOperator, SqlOperator> calciteToWrapper = Maps.newIdentityHashMap();
    private final ArrayListMultimap<String, SqlOperator> drillOperatorsWithoutInferenceMap = ArrayListMultimap.create();
    private final ArrayListMultimap<String, SqlOperator> drillOperatorsWithInferenceMap = ArrayListMultimap.create();
    private int functionRegistryVersion;
    private final OptionManager systemOptionManager;

    public DrillOperatorTable(FunctionImplementationRegistry registry, OptionManager systemOptionManager) {
        registry.register(this);
        this.calciteOperators.addAll(inner.getOperatorList());
        this.populateWrappedCalciteOperators();
        this.systemOptionManager = systemOptionManager;
    }

    public void setFunctionRegistryVersion(int version) {
        this.functionRegistryVersion = version;
    }

    public int getFunctionRegistryVersion() {
        return this.functionRegistryVersion;
    }

    public void addOperatorWithoutInference(String name, SqlOperator op) {
        this.drillOperatorsWithoutInference.add(op);
        this.drillOperatorsWithoutInferenceMap.put((Object)name.toLowerCase(), (Object)op);
    }

    public void addOperatorWithInference(String name, SqlOperator op) {
        this.drillOperatorsWithInference.add(op);
        this.drillOperatorsWithInferenceMap.put((Object)name.toLowerCase(), (Object)op);
    }

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (this.isInferenceEnabled()) {
            this.populateFromTypeInference(opName, category, syntax, operatorList, nameMatcher);
        } else {
            this.populateFromWithoutTypeInference(opName, category, syntax, operatorList, nameMatcher);
        }
    }

    private void populateFromTypeInference(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        List drillOps;
        ArrayList<SqlOperator> calciteOperatorList = Lists.newArrayList();
        inner.lookupOperatorOverloads(opName, category, syntax, calciteOperatorList, nameMatcher);
        if (!calciteOperatorList.isEmpty()) {
            for (SqlOperator calciteOperator : calciteOperatorList) {
                if (this.calciteToWrapper.containsKey(calciteOperator)) {
                    operatorList.add(this.calciteToWrapper.get(calciteOperator));
                    continue;
                }
                operatorList.add(calciteOperator);
            }
        } else if (operatorList.isEmpty() && (syntax == SqlSyntax.FUNCTION || syntax == SqlSyntax.FUNCTION_ID) && opName.isSimple() && (drillOps = this.drillOperatorsWithInferenceMap.get((Object)opName.getSimple().toLowerCase())) != null && !drillOps.isEmpty()) {
            operatorList.addAll(drillOps);
        }
    }

    private void populateFromWithoutTypeInference(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        List drillOps;
        inner.lookupOperatorOverloads(opName, category, syntax, operatorList, nameMatcher);
        if (operatorList.isEmpty() && (syntax == SqlSyntax.FUNCTION || syntax == SqlSyntax.FUNCTION_ID) && opName.isSimple() && (drillOps = this.drillOperatorsWithoutInferenceMap.get((Object)opName.getSimple().toLowerCase())) != null) {
            operatorList.addAll(drillOps);
        }
    }

    public List<SqlOperator> getOperatorList() {
        ArrayList<SqlOperator> sqlOperators = Lists.newArrayList();
        sqlOperators.addAll(this.calciteOperators);
        if (this.isInferenceEnabled()) {
            sqlOperators.addAll(this.drillOperatorsWithInference);
        } else {
            sqlOperators.addAll(this.drillOperatorsWithoutInference);
        }
        return sqlOperators;
    }

    public List<SqlOperator> getSqlOperator(String name) {
        if (this.isInferenceEnabled()) {
            return this.drillOperatorsWithInferenceMap.get((Object)name.toLowerCase());
        }
        return this.drillOperatorsWithoutInferenceMap.get((Object)name.toLowerCase());
    }

    private void populateWrappedCalciteOperators() {
        for (SqlOperator calciteOperator : inner.getOperatorList()) {
            DrillCalciteSqlWrapper wrapper;
            if (calciteOperator instanceof SqlSumEmptyIsZeroAggFunction) {
                wrapper = new DrillCalciteSqlSumEmptyIsZeroAggFunctionWrapper((SqlSumEmptyIsZeroAggFunction)calciteOperator, this.getFunctionListWithInference(calciteOperator.getName()));
            } else if (calciteOperator instanceof SqlAggFunction) {
                wrapper = new DrillCalciteSqlAggFunctionWrapper((SqlAggFunction)calciteOperator, this.getFunctionListWithInference(calciteOperator.getName()));
            } else if (calciteOperator instanceof SqlFunction) {
                wrapper = new DrillCalciteSqlFunctionWrapper((SqlFunction)calciteOperator, this.getFunctionListWithInference(calciteOperator.getName()));
            } else if (calciteOperator instanceof SqlBetweenOperator) {
                SqlBetweenOperator sqlBetweenOperator = (SqlBetweenOperator)calciteOperator;
                wrapper = new DrillCalciteSqlBetweenOperatorWrapper(sqlBetweenOperator);
            } else {
                String drillOpName = calciteOperator == SqlStdOperatorTable.UNARY_MINUS || calciteOperator == SqlStdOperatorTable.UNARY_PLUS ? calciteOperator.getName() : FunctionCallFactory.convertToDrillFunctionName(calciteOperator.getName());
                List<DrillFuncHolder> drillFuncHolders = this.getFunctionListWithInference(drillOpName);
                if (drillFuncHolders.isEmpty()) continue;
                wrapper = new DrillCalciteSqlOperatorWrapper(calciteOperator, drillOpName, drillFuncHolders);
            }
            this.calciteToWrapper.put(calciteOperator, (SqlOperator)wrapper);
        }
    }

    private List<DrillFuncHolder> getFunctionListWithInference(String name) {
        ArrayList<DrillFuncHolder> functions = Lists.newArrayList();
        for (SqlOperator sqlOperator : this.drillOperatorsWithInferenceMap.get((Object)name.toLowerCase())) {
            List<DrillFuncHolder> list;
            if (sqlOperator instanceof DrillSqlOperator && (list = ((DrillSqlOperator)sqlOperator).getFunctions()) != null) {
                functions.addAll(list);
            }
            if (!(sqlOperator instanceof DrillSqlAggOperator) || (list = ((DrillSqlAggOperator)sqlOperator).getFunctions()) == null) continue;
            functions.addAll(list);
        }
        return functions;
    }

    private boolean isInferenceEnabled() {
        return this.systemOptionManager.getOption(PlannerSettings.TYPE_INFERENCE);
    }
}

