/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.util.Optionality;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.planner.sql.Checker;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;

public class DrillSqlAggOperator
extends SqlAggFunction {
    private final List<DrillFuncHolder> functions;

    protected DrillSqlAggOperator(String name, List<DrillFuncHolder> functions, SqlOperandTypeChecker operandTypeChecker, SqlReturnTypeInference sqlReturnTypeInference) {
        super(name, new SqlIdentifier(name, SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, sqlReturnTypeInference, null, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        this.functions = functions;
    }

    public List<DrillFuncHolder> getFunctions() {
        return this.functions;
    }

    public static class DrillSqlAggOperatorBuilder {
        private String name = null;
        private final List<DrillFuncHolder> functions = new ArrayList<DrillFuncHolder>();
        private int argCountMin = Integer.MAX_VALUE;
        private int argCountMax = Integer.MIN_VALUE;

        public DrillSqlAggOperatorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DrillSqlAggOperatorBuilder addFunctions(Collection<DrillFuncHolder> functions) {
            this.functions.addAll(functions);
            return this;
        }

        public DrillSqlAggOperatorBuilder setArgumentCount(int argCountMin, int argCountMax) {
            this.argCountMin = Math.min(this.argCountMin, argCountMin);
            this.argCountMax = Math.max(this.argCountMax, argCountMax);
            return this;
        }

        public DrillSqlAggOperator build() {
            if (this.name == null || this.functions.isEmpty()) {
                throw new AssertionError((Object)"The fields, name and functions, need to be set before build DrillSqlAggOperator");
            }
            boolean isVarArg = false;
            for (DrillFuncHolder function : this.functions) {
                if (!function.isVarArg()) continue;
                isVarArg = true;
            }
            return new DrillSqlAggOperator(this.name, this.functions, (SqlOperandTypeChecker)(isVarArg ? OperandTypes.VARIADIC : Checker.getChecker(this.argCountMin, this.argCountMax)), TypeInferenceUtils.getDrillSqlReturnTypeInference(this.name, this.functions));
        }
    }
}

