/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.planner.sql.Checker;
import org.apache.drill.exec.planner.sql.DynamicReturnType;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillSqlOperator
extends SqlFunction {
    private final boolean isDeterministic;
    private final boolean isNiladic;
    private final List<DrillFuncHolder> functions;

    @Deprecated
    public DrillSqlOperator(String name, int argCount, boolean isDeterministic, boolean isNiladic) {
        this(name, argCount, isDeterministic, (SqlReturnTypeInference)DynamicReturnType.INSTANCE, isNiladic);
    }

    @Deprecated
    public DrillSqlOperator(String name, int argCount, boolean isDeterministic, SqlReturnTypeInference sqlReturnTypeInference, boolean isNiladic) {
        this(name, new ArrayList<DrillFuncHolder>(), Checker.getChecker(argCount, argCount), isDeterministic, sqlReturnTypeInference, isNiladic);
    }

    @Deprecated
    public DrillSqlOperator(String name, int argCount, boolean isDeterministic, RelDataType type, boolean isNiladic) {
        this(name, new ArrayList<DrillFuncHolder>(), Checker.getChecker(argCount, argCount), isDeterministic, opBinding -> type, isNiladic);
    }

    protected DrillSqlOperator(String name, List<DrillFuncHolder> functions, SqlOperandTypeChecker operandTypeChecker, boolean isDeterministic, SqlReturnTypeInference sqlReturnTypeInference, boolean isNiladic) {
        super(new SqlIdentifier(name, SqlParserPos.ZERO), sqlReturnTypeInference, null, operandTypeChecker, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        this.functions = functions;
        this.isDeterministic = isDeterministic;
        this.isNiladic = isNiladic;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isNiladic() {
        return this.isNiladic;
    }

    public List<DrillFuncHolder> getFunctions() {
        return this.functions;
    }

    public SqlSyntax getSyntax() {
        if (this.isNiladic) {
            return SqlSyntax.FUNCTION_ID;
        }
        return super.getSyntax();
    }

    public static class DrillSqlOperatorBuilder {
        private String name;
        private final List<DrillFuncHolder> functions = Lists.newArrayList();
        private int argCountMin = Integer.MAX_VALUE;
        private int argCountMax = Integer.MIN_VALUE;
        private boolean isDeterministic = true;
        private boolean isNiladic = false;
        private boolean isVarArg = false;

        public DrillSqlOperatorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DrillSqlOperatorBuilder addFunctions(Collection<DrillFuncHolder> functions) {
            this.functions.addAll(functions);
            return this;
        }

        public DrillSqlOperatorBuilder setArgumentCount(int argCountMin, int argCountMax) {
            this.argCountMin = Math.min(this.argCountMin, argCountMin);
            this.argCountMax = Math.max(this.argCountMax, argCountMax);
            return this;
        }

        public DrillSqlOperatorBuilder setVarArg(boolean isVarArg) {
            this.isVarArg = isVarArg;
            return this;
        }

        public DrillSqlOperatorBuilder setDeterministic(boolean isDeterministic) {
            if (this.isDeterministic) {
                this.isDeterministic = isDeterministic;
            }
            return this;
        }

        public DrillSqlOperatorBuilder setNiladic(boolean isNiladic) {
            this.isNiladic = isNiladic;
            return this;
        }

        public DrillSqlOperator build() {
            if (this.name == null || this.functions.isEmpty()) {
                throw new AssertionError((Object)"The fields, name and functions, need to be set before build DrillSqlAggOperator");
            }
            return new DrillSqlOperator(this.name, this.functions, (SqlOperandTypeChecker)(this.isVarArg ? OperandTypes.VARIADIC : Checker.getChecker(this.argCountMin, this.argCountMax)), this.isDeterministic, TypeInferenceUtils.getDrillSqlReturnTypeInference(this.name, this.functions), this.isNiladic);
        }
    }
}

