/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.io.IOException;
import java.util.Collection;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.MetadataException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.QueryInputException;
import org.apache.drill.exec.planner.sql.conversion.SqlConverter;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.AnalyzeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DescribeSchemaHandler;
import org.apache.drill.exec.planner.sql.handlers.DescribeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.ExplainHandler;
import org.apache.drill.exec.planner.sql.handlers.InsertHandler;
import org.apache.drill.exec.planner.sql.handlers.MetastoreAnalyzeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.RefreshMetadataHandler;
import org.apache.drill.exec.planner.sql.handlers.ResetOptionHandler;
import org.apache.drill.exec.planner.sql.handlers.SchemaHandler;
import org.apache.drill.exec.planner.sql.handlers.SetOptionHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.planner.sql.parser.DrillSqlDescribeTable;
import org.apache.drill.exec.planner.sql.parser.DrillSqlResetOption;
import org.apache.drill.exec.planner.sql.parser.SqlSchema;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.shaded.guava.com.google.common.base.Throwables;
import org.apache.hadoop.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSqlWorker {
    private static final Logger logger = LoggerFactory.getLogger(DrillSqlWorker.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(DrillSqlWorker.class);

    private DrillSqlWorker() {
    }

    public static PhysicalPlan getPlan(QueryContext context, String sql) throws ForemanSetupException {
        return DrillSqlWorker.getPlan(context, sql, null);
    }

    public static PhysicalPlan getPlan(QueryContext context, String sql, Pointer<String> textPlan) throws ForemanSetupException {
        try {
            return DrillSqlWorker.convertPlan(context, sql, textPlan);
        }
        catch (ValidationException e) {
            String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw UserException.validationError(e).message(errorMessage, new Object[0]).build(logger);
        }
        catch (AccessControlException e) {
            throw UserException.permissionError(e).build(logger);
        }
        catch (SqlUnsupportedException e) {
            throw UserException.unsupportedError(e).build(logger);
        }
        catch (IOException | RelConversionException e) {
            throw new QueryInputException("Failure handling SQL.", e);
        }
    }

    private static PhysicalPlan convertPlan(QueryContext context, String sql, Pointer<String> textPlan) throws ForemanSetupException, RelConversionException, IOException, ValidationException {
        Pointer<String> textPlanCopy = textPlan == null ? null : new Pointer<String>((String)textPlan.value);
        long retryAttempts = context.getOption((String)"metastore.retrieval.retry_attempts").num_val;
        try {
            return DrillSqlWorker.getPhysicalPlan(context, sql, textPlan, retryAttempts);
        }
        catch (Exception e) {
            logger.trace("There was an error during conversion into physical plan.", (Throwable)e);
            boolean syncFuncsAndRetry = context.getSQLStatementType() != QueryContext.SqlStatementType.ANALYZE;
            syncFuncsAndRetry &= !(e instanceof UserException) || ((UserException)e).getErrorType() != UserBitShared.DrillPBError.ErrorType.PLUGIN;
            logger.trace("Will sync remote and local function registries if needed.");
            int funcRegistryVer = context.getDrillOperatorTable().getFunctionRegistryVersion();
            if (!(syncFuncsAndRetry &= context.getFunctionRegistry().syncWithRemoteRegistry(funcRegistryVer))) {
                throw e;
            }
            context.reloadDrillOperatorTable();
            logger.trace("Local function registry was synchronized with remote. Trying to find function one more time.");
            return DrillSqlWorker.getPhysicalPlan(context, sql, textPlanCopy, retryAttempts);
        }
    }

    private static PhysicalPlan getPhysicalPlan(QueryContext context, String sql, Pointer<String> textPlan, long retryAttempts) throws ForemanSetupException, RelConversionException, IOException, ValidationException {
        try {
            return DrillSqlWorker.getQueryPlan(context, sql, textPlan);
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause(e);
            if (rootCause instanceof MetadataException) {
                context.clearSQLStatementType();
                switch (((MetadataException)rootCause).getExceptionType()) {
                    case OUTDATED_METADATA: {
                        logger.warn("Metastore table metadata is outdated. Retrying to obtain query plan without Metastore usage.");
                        break;
                    }
                    case INCONSISTENT_METADATA: {
                        if (retryAttempts > 0L) {
                            logger.debug("Table metadata was changed during query planning. Retrying to obtain query plan using updated metadata.");
                            return DrillSqlWorker.getPhysicalPlan(context, sql, textPlan, --retryAttempts);
                        }
                        logger.warn("Table metadata was changing during query planning for all `metastore.retrieval.retry_attempts` = {} attempts.", (Object)context.getOption((String)"metastore.retrieval.retry_attempts").num_val);
                        break;
                    }
                    default: {
                        logger.error("Exception happened during query planning using Metastore: {}", (Object)rootCause.getMessage(), (Object)rootCause);
                    }
                }
                logger.warn("Retrying to obtain query plan without Metastore usage.");
                context.getOptions().setLocalOption("metastore.enabled", false);
                return DrillSqlWorker.getQueryPlan(context, sql, textPlan);
            }
            throw e;
        }
    }

    private static PhysicalPlan getQueryPlan(QueryContext context, String sql, Pointer<String> textPlan) throws ForemanSetupException, RelConversionException, IOException, ValidationException {
        boolean newReturnResultSetValue;
        AbstractSqlHandler handler;
        SqlConverter parser = new SqlConverter(context);
        injector.injectChecked(context.getExecutionControls(), "sql-parsing", ForemanSetupException.class);
        SqlNode sqlNode = DrillSqlWorker.checkAndApplyAutoLimit(parser, context, sql);
        SqlHandlerConfig config = new SqlHandlerConfig(context, parser);
        switch (sqlNode.getKind()) {
            case EXPLAIN: {
                handler = new ExplainHandler(config, textPlan);
                context.setSQLStatementType(QueryContext.SqlStatementType.EXPLAIN);
                break;
            }
            case SET_OPTION: {
                handler = sqlNode instanceof DrillSqlResetOption ? new ResetOptionHandler(context) : new SetOptionHandler(context);
                context.setSQLStatementType(QueryContext.SqlStatementType.SETOPTION);
                break;
            }
            case DESCRIBE_TABLE: {
                if (sqlNode instanceof DrillSqlDescribeTable) {
                    handler = new DescribeTableHandler(config);
                    context.setSQLStatementType(QueryContext.SqlStatementType.DESCRIBE_TABLE);
                    break;
                }
            }
            case DESCRIBE_SCHEMA: {
                if (sqlNode instanceof SqlDescribeSchema) {
                    handler = new DescribeSchemaHandler(config);
                    context.setSQLStatementType(QueryContext.SqlStatementType.DESCRIBE_SCHEMA);
                    break;
                }
                if (sqlNode instanceof SqlSchema.Describe) {
                    handler = new SchemaHandler.Describe(config);
                    context.setSQLStatementType(QueryContext.SqlStatementType.DESCRIBE_SCHEMA);
                    break;
                }
            }
            case CREATE_TABLE: {
                handler = ((DrillSqlCall)sqlNode).getSqlHandler(config, textPlan);
                context.setSQLStatementType(QueryContext.SqlStatementType.CTAS);
                break;
            }
            case INSERT: {
                handler = new InsertHandler(config, textPlan);
                context.setSQLStatementType(QueryContext.SqlStatementType.INSERT);
                break;
            }
            case SELECT: {
                handler = new DefaultSqlHandler(config, textPlan);
                context.setSQLStatementType(QueryContext.SqlStatementType.SELECT);
                break;
            }
            case DROP_TABLE: 
            case CREATE_VIEW: 
            case DROP_VIEW: 
            case OTHER_DDL: 
            case OTHER: {
                if (sqlNode instanceof DrillSqlCall) {
                    handler = ((DrillSqlCall)sqlNode).getSqlHandler(config);
                    if (handler instanceof AnalyzeTableHandler || handler instanceof MetastoreAnalyzeTableHandler) {
                        context.setSQLStatementType(QueryContext.SqlStatementType.ANALYZE);
                        break;
                    }
                    if (handler instanceof RefreshMetadataHandler) {
                        context.setSQLStatementType(QueryContext.SqlStatementType.REFRESH);
                        break;
                    }
                    context.setSQLStatementType(QueryContext.SqlStatementType.OTHER);
                    break;
                }
            }
            default: {
                handler = new DefaultSqlHandler(config, textPlan);
                context.setSQLStatementType(QueryContext.SqlStatementType.OTHER);
            }
        }
        boolean currentReturnResultValue = context.getOptions().getBoolean("exec.query.return_result_set_for_ddl");
        boolean bl = newReturnResultSetValue = currentReturnResultValue || !SqlKind.DDL.contains(sqlNode.getKind());
        if (newReturnResultSetValue != currentReturnResultValue) {
            context.getOptions().setLocalOption("exec.query.return_result_set_for_ddl", true);
        }
        return handler.getPlan(sqlNode);
    }

    private static boolean isAutoLimitShouldBeApplied(SqlNode sqlNode, int queryMaxRows) {
        return queryMaxRows > 0 && sqlNode.getKind().belongsTo((Collection)SqlKind.QUERY) && (sqlNode.getKind() != SqlKind.ORDER_BY || DrillSqlWorker.isAutoLimitLessThanOrderByFetch((SqlOrderBy)sqlNode, queryMaxRows));
    }

    private static SqlNode checkAndApplyAutoLimit(SqlConverter parser, QueryContext context, String sql) {
        int queryMaxRows;
        SqlNode sqlNode = parser.parse(sql);
        if (DrillSqlWorker.isAutoLimitShouldBeApplied(sqlNode, queryMaxRows = context.getOptions().getOption((String)"exec.query.max_rows").num_val.intValue())) {
            sqlNode = DrillSqlWorker.wrapWithAutoLimit(sqlNode, queryMaxRows);
        } else if (queryMaxRows > 0) {
            context.getOptions().setLocalOption("exec.query.max_rows", 0L);
        }
        return sqlNode;
    }

    private static boolean isAutoLimitLessThanOrderByFetch(SqlOrderBy orderBy, int queryMaxRows) {
        return orderBy.fetch == null || Integer.parseInt(orderBy.fetch.toString()) > queryMaxRows;
    }

    private static SqlNode wrapWithAutoLimit(SqlNode sqlNode, int queryMaxRows) {
        SqlNumericLiteral autoLimitLiteral = SqlLiteral.createExactNumeric((String)String.valueOf(queryMaxRows), (SqlParserPos)SqlParserPos.ZERO);
        if (sqlNode.getKind() == SqlKind.ORDER_BY) {
            SqlOrderBy orderBy = (SqlOrderBy)sqlNode;
            return new SqlOrderBy(orderBy.getParserPosition(), orderBy.query, orderBy.orderList, orderBy.offset, (SqlNode)autoLimitLiteral);
        }
        return new SqlOrderBy(SqlParserPos.ZERO, sqlNode, SqlNodeList.EMPTY, null, (SqlNode)autoLimitLiteral);
    }
}

