/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandingConcurrentMap<KEY, VALUE>
implements ConcurrentMap<KEY, VALUE> {
    static final Logger logger = LoggerFactory.getLogger(ExpandingConcurrentMap.class);
    private final ConcurrentMap<KEY, VALUE> internalMap = Maps.newConcurrentMap();
    private final DelegatingKeySet keySet = new DelegatingKeySet();
    private final MapValueFactory<KEY, VALUE> fac;

    public ExpandingConcurrentMap(MapValueFactory<KEY, VALUE> fac) {
        this.fac = fac;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public boolean alreadyContainsKey(Object k) {
        Object key = k;
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsKey(Object k) {
        Object key = k;
        if (this.internalMap.containsKey(key)) {
            return true;
        }
        VALUE v = this.getNewEntry(k);
        return v != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VALUE get(Object key) {
        Object out = this.internalMap.get(key);
        if (out != null) {
            return (VALUE)out;
        }
        return this.getNewEntry(key);
    }

    private VALUE getNewEntry(Object k) {
        Object key = k;
        VALUE v = this.fac.create(key);
        if (v == null) {
            return null;
        }
        VALUE old = this.internalMap.putIfAbsent(key, v);
        if (old == null) {
            return v;
        }
        this.fac.destroy(v);
        return old;
    }

    @Override
    public VALUE put(KEY key, VALUE value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VALUE remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<KEY> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<VALUE> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<KEY, VALUE>> entrySet() {
        return this.internalMap.entrySet();
    }

    @Override
    public VALUE putIfAbsent(KEY key, VALUE value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return false;
    }

    @Override
    public boolean replace(KEY key, VALUE oldValue, VALUE newValue) {
        return false;
    }

    @Override
    public VALUE replace(KEY key, VALUE value) {
        return null;
    }

    private class DelegatingKeySet
    implements Set<KEY> {
        private DelegatingKeySet() {
        }

        @Override
        public int size() {
            return ExpandingConcurrentMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ExpandingConcurrentMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ExpandingConcurrentMap.this.containsKey(o);
        }

        @Override
        public Iterator<KEY> iterator() {
            return ExpandingConcurrentMap.this.internalMap.keySet().iterator();
        }

        @Override
        public Object[] toArray() {
            return ExpandingConcurrentMap.this.internalMap.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ExpandingConcurrentMap.this.internalMap.keySet().toArray(a);
        }

        @Override
        public boolean add(KEY e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (!this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends KEY> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface MapValueFactory<KEY, VALUE> {
        public VALUE create(KEY var1);

        public void destroy(VALUE var1);
    }
}

