/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.MajorTypeInLogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.FunctionResolverFactory;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeInferenceUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypeInferenceUtils.class);
    public static final TypeProtos.MajorType UNKNOWN_TYPE = TypeProtos.MajorType.getDefaultInstance();
    private static final ImmutableMap<TypeProtos.MinorType, SqlTypeName> DRILL_TO_CALCITE_TYPE_MAPPING = ImmutableMap.builder().put(TypeProtos.MinorType.INT, SqlTypeName.INTEGER).put(TypeProtos.MinorType.BIGINT, SqlTypeName.BIGINT).put(TypeProtos.MinorType.FLOAT4, SqlTypeName.FLOAT).put(TypeProtos.MinorType.FLOAT8, SqlTypeName.DOUBLE).put(TypeProtos.MinorType.VARCHAR, SqlTypeName.VARCHAR).put(TypeProtos.MinorType.BIT, SqlTypeName.BOOLEAN).put(TypeProtos.MinorType.DATE, SqlTypeName.DATE).put(TypeProtos.MinorType.DECIMAL9, SqlTypeName.DECIMAL).put(TypeProtos.MinorType.DECIMAL18, SqlTypeName.DECIMAL).put(TypeProtos.MinorType.DECIMAL28SPARSE, SqlTypeName.DECIMAL).put(TypeProtos.MinorType.DECIMAL38SPARSE, SqlTypeName.DECIMAL).put(TypeProtos.MinorType.VARDECIMAL, SqlTypeName.DECIMAL).put(TypeProtos.MinorType.TIME, SqlTypeName.TIME).put(TypeProtos.MinorType.TIMESTAMP, SqlTypeName.TIMESTAMP).put(TypeProtos.MinorType.VARBINARY, SqlTypeName.VARBINARY).put(TypeProtos.MinorType.INTERVALYEAR, SqlTypeName.INTERVAL_YEAR_MONTH).put(TypeProtos.MinorType.INTERVALDAY, SqlTypeName.INTERVAL_DAY).put(TypeProtos.MinorType.MAP, SqlTypeName.MAP).put(TypeProtos.MinorType.LIST, SqlTypeName.ARRAY).put(TypeProtos.MinorType.LATE, SqlTypeName.ANY).build();
    private static final ImmutableMap<SqlTypeName, TypeProtos.MinorType> CALCITE_TO_DRILL_MAPPING = ImmutableMap.builder().put(SqlTypeName.INTEGER, TypeProtos.MinorType.INT).put(SqlTypeName.BIGINT, TypeProtos.MinorType.BIGINT).put(SqlTypeName.FLOAT, TypeProtos.MinorType.FLOAT4).put(SqlTypeName.DOUBLE, TypeProtos.MinorType.FLOAT8).put(SqlTypeName.VARCHAR, TypeProtos.MinorType.VARCHAR).put(SqlTypeName.BOOLEAN, TypeProtos.MinorType.BIT).put(SqlTypeName.DATE, TypeProtos.MinorType.DATE).put(SqlTypeName.TIME, TypeProtos.MinorType.TIME).put(SqlTypeName.TIMESTAMP, TypeProtos.MinorType.TIMESTAMP).put(SqlTypeName.VARBINARY, TypeProtos.MinorType.VARBINARY).put(SqlTypeName.INTERVAL_YEAR, TypeProtos.MinorType.INTERVALYEAR).put(SqlTypeName.INTERVAL_YEAR_MONTH, TypeProtos.MinorType.INTERVALYEAR).put(SqlTypeName.INTERVAL_MONTH, TypeProtos.MinorType.INTERVALYEAR).put(SqlTypeName.INTERVAL_DAY, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_DAY_HOUR, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_DAY_MINUTE, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_DAY_SECOND, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_HOUR, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_HOUR_MINUTE, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_HOUR_SECOND, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_MINUTE, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_MINUTE_SECOND, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.INTERVAL_SECOND, TypeProtos.MinorType.INTERVALDAY).put(SqlTypeName.DECIMAL, TypeProtos.MinorType.VARDECIMAL).put(SqlTypeName.CHAR, TypeProtos.MinorType.VARCHAR).build();
    private static final ImmutableMap<String, SqlReturnTypeInference> funcNameToInference = ImmutableMap.builder().put("DATE_PART", DrillDatePartSqlReturnTypeInference.access$2000()).put(SqlStdOperatorTable.TIMESTAMP_ADD.getName(), (DrillDatePartSqlReturnTypeInference)DrillTimestampAddTypeInference.access$1900()).put(SqlKind.SUM.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillSumSqlReturnTypeInference.access$1800())).put(SqlKind.COUNT.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillCountSqlReturnTypeInference.access$1700())).put("CONCAT", (DrillDatePartSqlReturnTypeInference)((Object)DrillConcatSqlReturnTypeInference.access$1600())).put("CONCATOPERATOR", (DrillDatePartSqlReturnTypeInference)((Object)DrillConcatSqlReturnTypeInference.access$1500())).put("LENGTH", (DrillDatePartSqlReturnTypeInference)((Object)DrillLengthSqlReturnTypeInference.access$1400())).put("LPAD", (DrillDatePartSqlReturnTypeInference)((Object)DrillPadSqlReturnTypeInference.access$1300())).put("RPAD", (DrillDatePartSqlReturnTypeInference)((Object)DrillPadSqlReturnTypeInference.access$1300())).put(SqlKind.LTRIM.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillTrimSqlReturnTypeInference.access$1200())).put(SqlKind.RTRIM.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillTrimSqlReturnTypeInference.access$1200())).put("BTRIM", (DrillDatePartSqlReturnTypeInference)((Object)DrillTrimSqlReturnTypeInference.access$1200())).put(SqlKind.TRIM.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillTrimSqlReturnTypeInference.access$1200())).put("CONVERT_TO", (DrillDatePartSqlReturnTypeInference)((Object)DrillConvertToSqlReturnTypeInference.access$1100())).put(SqlKind.EXTRACT.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillExtractSqlReturnTypeInference.access$1000())).put("SQRT", (DrillDatePartSqlReturnTypeInference)((Object)DrillSqrtSqlReturnTypeInference.access$900())).put(SqlKind.CAST.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillCastSqlReturnTypeInference.access$800())).put("FLATTEN", (DrillDatePartSqlReturnTypeInference)((Object)DrillDeferToExecSqlReturnTypeInference.access$700())).put("KVGEN", (DrillDatePartSqlReturnTypeInference)((Object)DrillDeferToExecSqlReturnTypeInference.access$700())).put("CONVERT_FROM", (DrillDatePartSqlReturnTypeInference)((Object)DrillDeferToExecSqlReturnTypeInference.access$700())).put("LOWER", (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put("UPPER", (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put("INITCAP", (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put("REVERSE", (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put(SqlKind.CUME_DIST.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillRankingSqlReturnTypeInference.access$600())).put(SqlKind.DENSE_RANK.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillRankingSqlReturnTypeInference.access$500())).put(SqlKind.PERCENT_RANK.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillRankingSqlReturnTypeInference.access$600())).put(SqlKind.RANK.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillRankingSqlReturnTypeInference.access$500())).put(SqlKind.ROW_NUMBER.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillRankingSqlReturnTypeInference.access$500())).put(SqlKind.NTILE.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillNTILESqlReturnTypeInference.access$400())).put(SqlKind.LEAD.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillLeadLagSqlReturnTypeInference.access$300())).put(SqlKind.LAG.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillLeadLagSqlReturnTypeInference.access$300())).put(SqlKind.FIRST_VALUE.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put(SqlKind.LAST_VALUE.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$200())).put(SqlKind.AVG.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillAvgAggSqlReturnTypeInference.access$100())).put(SqlKind.STDDEV_POP.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillAvgAggSqlReturnTypeInference.access$100())).put(SqlKind.STDDEV_SAMP.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillAvgAggSqlReturnTypeInference.access$100())).put(SqlKind.VAR_POP.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillAvgAggSqlReturnTypeInference.access$100())).put(SqlKind.VAR_SAMP.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillAvgAggSqlReturnTypeInference.access$100())).put(SqlKind.MIN.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$000())).put(SqlKind.MAX.name(), (DrillDatePartSqlReturnTypeInference)((Object)DrillSameSqlReturnTypeInference.access$000())).build();
    private static final Set<String> SET_SCALE_DECIMAL_FUNCTIONS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("ROUND")).add("TRUNC")).add("TRUNCATE")).build();

    public static SqlTypeName getCalciteTypeFromDrillType(TypeProtos.MinorType type) {
        if (!DRILL_TO_CALCITE_TYPE_MAPPING.containsKey(type)) {
            return SqlTypeName.ANY;
        }
        return DRILL_TO_CALCITE_TYPE_MAPPING.get(type);
    }

    public static TypeProtos.MinorType getDrillTypeFromCalciteType(RelDataType relDataType) {
        SqlTypeName sqlTypeName = relDataType.getSqlTypeName();
        return TypeInferenceUtils.getDrillTypeFromCalciteType(sqlTypeName);
    }

    public static TypeProtos.MajorType getDrillMajorTypeFromCalciteType(RelDataType relDataType) {
        SqlTypeName sqlTypeName = relDataType.getSqlTypeName();
        TypeProtos.MinorType minorType = TypeInferenceUtils.getDrillTypeFromCalciteType(sqlTypeName);
        TypeProtos.MajorType.Builder typeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(minorType);
        switch (minorType) {
            case VAR16CHAR: 
            case VARCHAR: 
            case VARBINARY: 
            case TIMESTAMP: {
                if (relDataType.getPrecision() <= 0) break;
                typeBuilder.setPrecision(relDataType.getPrecision());
                break;
            }
            case VARDECIMAL: {
                typeBuilder.setPrecision(relDataType.getPrecision());
                typeBuilder.setScale(relDataType.getScale());
            }
        }
        if (relDataType.isNullable()) {
            typeBuilder.setMode(TypeProtos.DataMode.OPTIONAL);
        } else {
            typeBuilder.setMode(TypeProtos.DataMode.REQUIRED);
        }
        return typeBuilder.build();
    }

    public static TypeProtos.MinorType getDrillTypeFromCalciteType(SqlTypeName sqlTypeName) {
        if (!CALCITE_TO_DRILL_MAPPING.containsKey(sqlTypeName)) {
            return TypeProtos.MinorType.LATE;
        }
        return CALCITE_TO_DRILL_MAPPING.get(sqlTypeName);
    }

    public static SqlReturnTypeInference getDrillSqlReturnTypeInference(String name, List<DrillFuncHolder> functions) {
        String nameCap = name.toUpperCase();
        if (funcNameToInference.containsKey(nameCap)) {
            return funcNameToInference.get(nameCap);
        }
        return new DrillDefaultSqlReturnTypeInference(functions);
    }

    public static boolean isScalarStringType(SqlTypeName sqlTypeName) {
        return sqlTypeName == SqlTypeName.VARCHAR || sqlTypeName == SqlTypeName.CHAR;
    }

    private static DrillFuncHolder resolveDrillFuncHolder(SqlOperatorBinding opBinding, List<DrillFuncHolder> functions, FunctionCall functionCall) {
        FunctionResolver functionResolver = FunctionResolverFactory.getResolver(functionCall);
        DrillFuncHolder func = functionResolver.getBestMatch(functions, functionCall);
        if (func == null) {
            StringBuilder operandTypes = new StringBuilder();
            for (int i = 0; i < opBinding.getOperandCount(); ++i) {
                RelDataType operandType = opBinding.getOperandType(i);
                operandTypes.append(operandType.getSqlTypeName());
                if (operandType.isNullable()) {
                    operandTypes.append(":OPTIONAL");
                }
                if (i >= opBinding.getOperandCount() - 1) continue;
                operandTypes.append(",");
            }
            throw UserException.functionError().message(String.format("%s does not support operand types (%s)", opBinding.getOperator().getName(), operandTypes.toString()), new Object[0]).build(logger);
        }
        return func;
    }

    public static SqlTypeName getSqlTypeNameForTimeUnit(String timeUnitStr) {
        TimeUnit timeUnit = timeUnitStr.contentEquals("DAYOFWEEK") ? TimeUnit.DOW : (timeUnitStr.contentEquals("DAYOFYEAR") ? TimeUnit.DOY : TimeUnit.valueOf(timeUnitStr));
        switch (timeUnit) {
            case DAY: 
            case WEEK: 
            case MONTH: 
            case QUARTER: 
            case YEAR: 
            case MINUTE: 
            case HOUR: 
            case EPOCH: 
            case DOY: 
            case DOW: {
                return SqlTypeName.BIGINT;
            }
            case SECOND: {
                return SqlTypeName.DOUBLE;
            }
        }
        throw UserException.functionError().message("extract function supports the following time units: YEAR, QUARTER, MONTH, WEEK, DAY, DAYOFWEEK, DAYOFYEAR, EPOCH, HOUR, MINUTE, SECOND", new Object[0]).build(logger);
    }

    public static RelDataType createCalciteTypeWithNullability(RelDataTypeFactory typeFactory, SqlTypeName sqlTypeName, boolean isNullable) {
        RelDataType type = sqlTypeName.getFamily() == SqlTypeFamily.INTERVAL_DAY_TIME ? typeFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO)) : (sqlTypeName.getFamily() == SqlTypeFamily.INTERVAL_YEAR_MONTH ? typeFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO)) : (sqlTypeName == SqlTypeName.VARCHAR ? typeFactory.createSqlType(sqlTypeName, 65535) : typeFactory.createSqlType(sqlTypeName)));
        return typeFactory.createTypeWithNullability(type, isNullable);
    }

    public static RelDataType convertToCalciteType(RelDataTypeFactory typeFactory, TypeProtos.MajorType drillType, boolean isNullable) {
        SqlTypeName sqlTypeName = TypeInferenceUtils.getCalciteTypeFromDrillType(drillType.getMinorType());
        switch (sqlTypeName) {
            case DECIMAL: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(sqlTypeName, drillType.getPrecision(), drillType.getScale()), isNullable);
            }
            case TIME: 
            case TIMESTAMP: {
                int precision = drillType.hasPrecision() ? drillType.getPrecision() : typeFactory.getTypeSystem().getDefaultPrecision(sqlTypeName);
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(sqlTypeName, precision), isNullable);
            }
        }
        return TypeInferenceUtils.createCalciteTypeWithNullability(typeFactory, sqlTypeName, isNullable);
    }

    public static FunctionCall convertSqlOperatorBindingToFunctionCall(SqlOperatorBinding opBinding) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (int i = 0; i < opBinding.getOperandCount(); ++i) {
            RelDataType type = opBinding.getOperandType(i);
            TypeProtos.MinorType minorType = TypeInferenceUtils.getDrillTypeFromCalciteType(type);
            TypeProtos.DataMode dataMode = type.isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
            TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMode(dataMode).setMinorType(minorType);
            if (Types.isDecimalType(minorType)) {
                builder.setScale(type.getScale()).setPrecision(type.getPrecision());
            }
            args.add(new MajorTypeInLogicalExpression(builder.build()));
        }
        String drillFuncName = FunctionCallFactory.convertToDrillFunctionName(opBinding.getOperator().getName());
        return new FunctionCall(drillFuncName, args, ExpressionPosition.UNKNOWN);
    }

    private static boolean isNullable(List<RelDataType> operandTypes) {
        for (RelDataType relDataType : operandTypes) {
            if (!relDataType.isNullable()) continue;
            return true;
        }
        return false;
    }

    private TypeInferenceUtils() {
    }

    private static class DrillDefaultSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private final List<DrillFuncHolder> functions;

        public DrillDefaultSqlReturnTypeInference(List<DrillFuncHolder> functions) {
            this.functions = functions;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            if (this.functions.isEmpty()) {
                return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
            }
            for (RelDataType type : opBinding.collectOperandTypes()) {
                if (TypeInferenceUtils.getDrillTypeFromCalciteType(type) == TypeProtos.MinorType.LATE) {
                    boolean allBooleanOutput = true;
                    boolean isNullable = false;
                    for (DrillFuncHolder function : this.functions) {
                        if (function.getReturnType().getMinorType() != TypeProtos.MinorType.BIT) {
                            allBooleanOutput = false;
                            break;
                        }
                        if (function.getReturnType().getMode() != TypeProtos.DataMode.OPTIONAL && function.getNullHandling() != FunctionTemplate.NullHandling.NULL_IF_NULL) continue;
                        isNullable = true;
                    }
                    if (allBooleanOutput) {
                        return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.BOOLEAN), isNullable);
                    }
                    return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
                }
                if (!SET_SCALE_DECIMAL_FUNCTIONS.contains(opBinding.getOperator().getName()) || TypeInferenceUtils.getDrillTypeFromCalciteType(type) != TypeProtos.MinorType.VARDECIMAL) continue;
                return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
            }
            FunctionCall functionCall = TypeInferenceUtils.convertSqlOperatorBindingToFunctionCall(opBinding);
            DrillFuncHolder func = TypeInferenceUtils.resolveDrillFuncHolder(opBinding, this.functions, functionCall);
            RelDataType returnType = DrillDefaultSqlReturnTypeInference.getReturnType(opBinding, func.getReturnType(functionCall.args()), func.getNullHandling());
            return returnType.getSqlTypeName() == SqlTypeName.VARBINARY ? TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.ANY, returnType.isNullable()) : returnType;
        }

        private static RelDataType getReturnType(SqlOperatorBinding opBinding, TypeProtos.MajorType returnType, FunctionTemplate.NullHandling nullHandling) {
            boolean isNullable;
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            RelDataType nullableAnyType = factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
            if (UNKNOWN_TYPE.equals(returnType)) {
                return nullableAnyType;
            }
            TypeProtos.MinorType minorType = returnType.getMinorType();
            SqlTypeName sqlTypeName = TypeInferenceUtils.getCalciteTypeFromDrillType(minorType);
            if (sqlTypeName == null) {
                return nullableAnyType;
            }
            block0 : switch (returnType.getMode()) {
                case REPEATED: 
                case OPTIONAL: {
                    isNullable = true;
                    break;
                }
                case REQUIRED: {
                    switch (nullHandling) {
                        case INTERNAL: {
                            isNullable = false;
                            break block0;
                        }
                        case NULL_IF_NULL: {
                            boolean isNull = false;
                            for (int i = 0; i < opBinding.getOperandCount(); ++i) {
                                if (!opBinding.getOperandType(i).isNullable()) continue;
                                isNull = true;
                                break;
                            }
                            isNullable = isNull;
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return TypeInferenceUtils.convertToCalciteType(factory, returnType, isNullable);
        }
    }

    private static class DrillDatePartSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillDatePartSqlReturnTypeInference INSTANCE = new DrillDatePartSqlReturnTypeInference();

        private DrillDatePartSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            boolean isNullable = opBinding.getOperandType(1).isNullable();
            if (!(opBinding instanceof SqlCallBinding) || !(((SqlCallBinding)opBinding).operand(0) instanceof SqlCharStringLiteral)) {
                return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.ANY, isNullable);
            }
            String part = ((SqlCharStringLiteral)((SqlCallBinding)opBinding).operand(0)).getNlsString().getValue().toUpperCase();
            SqlTypeName sqlTypeName = TypeInferenceUtils.getSqlTypeNameForTimeUnit(part);
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, sqlTypeName, isNullable);
        }

        static /* synthetic */ DrillDatePartSqlReturnTypeInference access$2000() {
            return INSTANCE;
        }
    }

    private static class DrillTimestampAddTypeInference
    implements SqlReturnTypeInference {
        private static final SqlReturnTypeInference INSTANCE = new DrillTimestampAddTypeInference();

        private DrillTimestampAddTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            SqlTypeName sqlTypeName;
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            RelDataType inputType = opBinding.getOperandType(2);
            boolean isNullable = inputType.isNullable() || opBinding.getOperandType(1).isNullable();
            SqlTypeName inputTypeName = inputType.getSqlTypeName();
            TimeUnit qualifier = ((SqlIntervalQualifier)((SqlCallBinding)opBinding).operand(0)).getUnit();
            int precision = 0;
            switch (qualifier) {
                case DAY: 
                case WEEK: 
                case MONTH: 
                case QUARTER: 
                case YEAR: 
                case NANOSECOND: {
                    precision = 3;
                    sqlTypeName = inputTypeName;
                    break;
                }
                case MICROSECOND: 
                case MILLISECOND: {
                    precision = 3;
                    sqlTypeName = SqlTypeName.TIMESTAMP;
                    break;
                }
                case SECOND: 
                case MINUTE: 
                case HOUR: {
                    precision = 3;
                    if (inputTypeName == SqlTypeName.TIME) {
                        sqlTypeName = SqlTypeName.TIME;
                        break;
                    }
                    sqlTypeName = SqlTypeName.TIMESTAMP;
                    break;
                }
                default: {
                    sqlTypeName = SqlTypeName.ANY;
                }
            }
            if (inputType.getSqlTypeName().allowsPrecNoScale()) {
                RelDataType type = factory.createSqlType(sqlTypeName, precision);
                return factory.createTypeWithNullability(type, isNullable);
            }
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), sqlTypeName, isNullable);
        }

        static /* synthetic */ SqlReturnTypeInference access$1900() {
            return INSTANCE;
        }
    }

    private static class DrillSumSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillSumSqlReturnTypeInference INSTANCE = new DrillSumSqlReturnTypeInference();

        private DrillSumSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            boolean isNullable;
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            boolean bl = isNullable = opBinding.getGroupCount() == 0 || opBinding.getOperandType(0).isNullable();
            if (TypeInferenceUtils.getDrillTypeFromCalciteType(opBinding.getOperandType(0)) == TypeProtos.MinorType.LATE) {
                return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.ANY, isNullable);
            }
            RelDataType operandType = opBinding.getOperandType(0);
            TypeProtos.MinorType inputMinorType = TypeInferenceUtils.getDrillTypeFromCalciteType(operandType);
            Optional<TypeProtos.MinorType> targetType = TypeCastRules.getCheapestCast(inputMinorType, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.FLOAT8, TypeProtos.MinorType.VARDECIMAL);
            if (!targetType.isPresent()) {
                throw UserException.functionError().message(String.format("%s does not support operand types (%s)", opBinding.getOperator().getName(), opBinding.getOperandType(0).getSqlTypeName()), new Object[0]).build(logger);
            }
            switch (targetType.get()) {
                case BIGINT: {
                    return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.BIGINT, isNullable);
                }
                case FLOAT8: {
                    return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.DOUBLE, isNullable);
                }
                case VARDECIMAL: {
                    RelDataType sqlType = factory.createSqlType(SqlTypeName.DECIMAL, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), Math.min(operandType.getScale(), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericScale()));
                    return factory.createTypeWithNullability(sqlType, isNullable);
                }
            }
            throw new IllegalStateException(String.format("Internal error: a minor type of %s should not occur here.", targetType.get()));
        }

        static /* synthetic */ DrillSumSqlReturnTypeInference access$1800() {
            return INSTANCE;
        }
    }

    private static class DrillCountSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillCountSqlReturnTypeInference INSTANCE = new DrillCountSqlReturnTypeInference();

        private DrillCountSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            SqlTypeName type = SqlTypeName.BIGINT;
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, type, false);
        }

        static /* synthetic */ DrillCountSqlReturnTypeInference access$1700() {
            return INSTANCE;
        }
    }

    private static class DrillConcatSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillConcatSqlReturnTypeInference INSTANCE_CONCAT = new DrillConcatSqlReturnTypeInference(false);
        private static final DrillConcatSqlReturnTypeInference INSTANCE_CONCAT_OP = new DrillConcatSqlReturnTypeInference(true);
        private final boolean isNullIfNull;

        public DrillConcatSqlReturnTypeInference(boolean isNullIfNull) {
            this.isNullIfNull = isNullIfNull;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            int totalPrecision = 0;
            for (RelDataType relDataType : opBinding.collectOperandTypes()) {
                if (TypeInferenceUtils.isScalarStringType(relDataType.getSqlTypeName()) && relDataType.getPrecision() != -1) {
                    totalPrecision += relDataType.getPrecision();
                    continue;
                }
                totalPrecision = 65535;
                break;
            }
            totalPrecision = totalPrecision > 65535 ? 65535 : totalPrecision;
            boolean isNullable = this.isNullIfNull && TypeInferenceUtils.isNullable(opBinding.collectOperandTypes());
            return opBinding.getTypeFactory().createTypeWithNullability(opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, totalPrecision), isNullable);
        }

        static /* synthetic */ DrillConcatSqlReturnTypeInference access$1500() {
            return INSTANCE_CONCAT_OP;
        }

        static /* synthetic */ DrillConcatSqlReturnTypeInference access$1600() {
            return INSTANCE_CONCAT;
        }
    }

    private static class DrillLengthSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillLengthSqlReturnTypeInference INSTANCE = new DrillLengthSqlReturnTypeInference();

        private DrillLengthSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            SqlTypeName sqlTypeName = SqlTypeName.BIGINT;
            boolean isNullable = opBinding.getOperandType(0).isNullable();
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, sqlTypeName, isNullable);
        }

        static /* synthetic */ DrillLengthSqlReturnTypeInference access$1400() {
            return INSTANCE;
        }
    }

    private static class DrillPadSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillPadSqlReturnTypeInference INSTANCE = new DrillPadSqlReturnTypeInference();

        private DrillPadSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (opBinding instanceof SqlCallBinding && ((SqlCallBinding)opBinding).operand(1) instanceof SqlNumericLiteral) {
                int precision = ((SqlNumericLiteral)((SqlCallBinding)opBinding).operand(1)).intValue(true);
                RelDataType sqlType = opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, Math.max(precision, 0));
                return opBinding.getTypeFactory().createTypeWithNullability(sqlType, TypeInferenceUtils.isNullable(opBinding.collectOperandTypes()));
            }
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), SqlTypeName.VARCHAR, TypeInferenceUtils.isNullable(opBinding.collectOperandTypes()));
        }

        static /* synthetic */ DrillPadSqlReturnTypeInference access$1300() {
            return INSTANCE;
        }
    }

    private static class DrillTrimSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillTrimSqlReturnTypeInference INSTANCE = new DrillTrimSqlReturnTypeInference();

        private DrillTrimSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), SqlTypeName.VARCHAR, TypeInferenceUtils.isNullable(opBinding.collectOperandTypes()));
        }

        static /* synthetic */ DrillTrimSqlReturnTypeInference access$1200() {
            return INSTANCE;
        }
    }

    private static class DrillConvertToSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillConvertToSqlReturnTypeInference INSTANCE = new DrillConvertToSqlReturnTypeInference();

        private DrillConvertToSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            SqlTypeName type = SqlTypeName.VARBINARY;
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, type, opBinding.getOperandType(0).isNullable());
        }

        static /* synthetic */ DrillConvertToSqlReturnTypeInference access$1100() {
            return INSTANCE;
        }
    }

    private static class DrillExtractSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillExtractSqlReturnTypeInference INSTANCE = new DrillExtractSqlReturnTypeInference();

        private DrillExtractSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            TimeUnit timeUnit = opBinding.getOperandType(0).getIntervalQualifier().getStartUnit();
            boolean isNullable = opBinding.getOperandType(1).isNullable();
            SqlTypeName sqlTypeName = TypeInferenceUtils.getSqlTypeNameForTimeUnit(timeUnit.name());
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, sqlTypeName, isNullable);
        }

        static /* synthetic */ DrillExtractSqlReturnTypeInference access$1000() {
            return INSTANCE;
        }
    }

    private static class DrillSqrtSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillSqrtSqlReturnTypeInference INSTANCE = new DrillSqrtSqlReturnTypeInference();

        private DrillSqrtSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            boolean isNullable = opBinding.getOperandType(0).isNullable();
            return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.DOUBLE, isNullable);
        }

        static /* synthetic */ DrillSqrtSqlReturnTypeInference access$900() {
            return INSTANCE;
        }
    }

    private static class DrillCastSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillCastSqlReturnTypeInference INSTANCE = new DrillCastSqlReturnTypeInference();

        private DrillCastSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            SqlCallBinding callBinding;
            SqlNode operand0;
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            boolean isNullable = opBinding.getOperandType(0).isNullable();
            RelDataType ret = factory.createTypeWithNullability(opBinding.getOperandType(1), isNullable);
            if (opBinding instanceof SqlCallBinding && ((operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0)) instanceof SqlLiteral && ((SqlLiteral)operand0).getValue() == null || operand0 instanceof SqlDynamicParam)) {
                callBinding.getValidator().setValidatedNodeType(operand0, ret);
            }
            return ret;
        }

        static /* synthetic */ DrillCastSqlReturnTypeInference access$800() {
            return INSTANCE;
        }
    }

    private static class DrillDeferToExecSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillDeferToExecSqlReturnTypeInference INSTANCE = new DrillDeferToExecSqlReturnTypeInference();

        private DrillDeferToExecSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            return factory.createTypeWithNullability(factory.createSqlType(SqlTypeName.ANY), true);
        }

        static /* synthetic */ DrillDeferToExecSqlReturnTypeInference access$700() {
            return INSTANCE;
        }
    }

    private static class DrillSameSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillSameSqlReturnTypeInference THE_SAME_RETURN_TYPE = new DrillSameSqlReturnTypeInference(true);
        private static final DrillSameSqlReturnTypeInference ALL_NULLABLE = new DrillSameSqlReturnTypeInference(false);
        private final boolean preserveNullability;

        public DrillSameSqlReturnTypeInference(boolean preserveNullability) {
            this.preserveNullability = preserveNullability;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (this.preserveNullability) {
                return opBinding.getOperandType(0);
            }
            return opBinding.getTypeFactory().createTypeWithNullability(opBinding.getOperandType(0), true);
        }

        static /* synthetic */ DrillSameSqlReturnTypeInference access$000() {
            return ALL_NULLABLE;
        }

        static /* synthetic */ DrillSameSqlReturnTypeInference access$200() {
            return THE_SAME_RETURN_TYPE;
        }
    }

    private static class DrillRankingSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillRankingSqlReturnTypeInference INSTANCE_BIGINT = new DrillRankingSqlReturnTypeInference(SqlTypeName.BIGINT);
        private static final DrillRankingSqlReturnTypeInference INSTANCE_DOUBLE = new DrillRankingSqlReturnTypeInference(SqlTypeName.DOUBLE);
        private final SqlTypeName returnType;

        private DrillRankingSqlReturnTypeInference(SqlTypeName returnType) {
            this.returnType = returnType;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), this.returnType, false);
        }

        static /* synthetic */ DrillRankingSqlReturnTypeInference access$500() {
            return INSTANCE_BIGINT;
        }

        static /* synthetic */ DrillRankingSqlReturnTypeInference access$600() {
            return INSTANCE_DOUBLE;
        }
    }

    private static class DrillNTILESqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillNTILESqlReturnTypeInference INSTANCE = new DrillNTILESqlReturnTypeInference();

        private DrillNTILESqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), SqlTypeName.INTEGER, opBinding.getOperandType(0).isNullable());
        }

        static /* synthetic */ DrillNTILESqlReturnTypeInference access$400() {
            return INSTANCE;
        }
    }

    private static class DrillLeadLagSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillLeadLagSqlReturnTypeInference INSTANCE = new DrillLeadLagSqlReturnTypeInference();

        private DrillLeadLagSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getTypeFactory().createTypeWithNullability(opBinding.getOperandType(0), true);
        }

        static /* synthetic */ DrillLeadLagSqlReturnTypeInference access$300() {
            return INSTANCE;
        }
    }

    private static class DrillAvgAggSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillAvgAggSqlReturnTypeInference INSTANCE = new DrillAvgAggSqlReturnTypeInference();

        private DrillAvgAggSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            boolean isNullable;
            RelDataTypeFactory factory = opBinding.getTypeFactory();
            boolean bl = isNullable = opBinding.getGroupCount() == 0 || opBinding.getOperandType(0).isNullable();
            if (TypeInferenceUtils.getDrillTypeFromCalciteType(opBinding.getOperandType(0)) == TypeProtos.MinorType.LATE) {
                return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.ANY, isNullable);
            }
            RelDataType operandType = opBinding.getOperandType(0);
            TypeProtos.MinorType inputMinorType = TypeInferenceUtils.getDrillTypeFromCalciteType(operandType);
            Optional<TypeProtos.MinorType> targetType = TypeCastRules.getCheapestCast(inputMinorType, TypeProtos.MinorType.FLOAT8, TypeProtos.MinorType.VARDECIMAL);
            if (!targetType.isPresent()) {
                throw UserException.functionError().message(String.format("%s does not support operand types (%s)", opBinding.getOperator().getName(), opBinding.getOperandType(0).getSqlTypeName()), new Object[0]).build(logger);
            }
            switch (targetType.get()) {
                case FLOAT8: {
                    return TypeInferenceUtils.createCalciteTypeWithNullability(factory, SqlTypeName.DOUBLE, isNullable);
                }
                case VARDECIMAL: {
                    RelDataType sqlType = factory.createSqlType(SqlTypeName.DECIMAL, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), Math.min(Math.max(6, operandType.getScale()), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericScale()));
                    return factory.createTypeWithNullability(sqlType, isNullable);
                }
            }
            throw new IllegalStateException(String.format("Internal error: a minor type of %s should not occur here.", targetType.get()));
        }

        static /* synthetic */ DrillAvgAggSqlReturnTypeInference access$100() {
            return INSTANCE;
        }
    }

    private static class DrillSubstringSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private static final DrillSubstringSqlReturnTypeInference INSTANCE = new DrillSubstringSqlReturnTypeInference();

        private DrillSubstringSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            boolean isNullable = TypeInferenceUtils.isNullable(opBinding.collectOperandTypes());
            boolean isScalarString = TypeInferenceUtils.isScalarStringType(opBinding.getOperandType(0).getSqlTypeName());
            int precision = opBinding.getOperandType(0).getPrecision();
            if (isScalarString && precision != -1) {
                RelDataType sqlType = opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, precision);
                return opBinding.getTypeFactory().createTypeWithNullability(sqlType, isNullable);
            }
            return TypeInferenceUtils.createCalciteTypeWithNullability(opBinding.getTypeFactory(), SqlTypeName.VARCHAR, isNullable);
        }
    }
}

