/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.conversion;

import java.util.List;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.DynamicSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.conversion.DrillTableKey;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillCalciteCatalogReader
extends CalciteCatalogReader {
    private static final Logger logger = LoggerFactory.getLogger(DrillCalciteCatalogReader.class);
    private final DrillConfig drillConfig;
    private final UserSession session;
    private boolean allowTemporaryTables;
    private final BooleanSupplier useRootSchema;
    private final LoadingCache<DrillTableKey, MetadataProviderManager> tableCache;

    DrillCalciteCatalogReader(SchemaPlus rootSchema, boolean caseSensitive, List<String> defaultSchema, JavaTypeFactory typeFactory, DrillConfig drillConfig, UserSession session, BooleanSupplier useRootSchema) {
        super(DynamicSchema.from((SchemaPlus)rootSchema), SqlNameMatchers.withCaseSensitive((boolean)caseSensitive), ImmutableList.of(defaultSchema, ImmutableList.of()), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)DrillCalciteCatalogReader.getConnectionConfig(caseSensitive));
        this.drillConfig = drillConfig;
        this.session = session;
        this.allowTemporaryTables = true;
        this.tableCache = CacheBuilder.newBuilder().build(new CacheLoader<DrillTableKey, MetadataProviderManager>(){

            @Override
            public MetadataProviderManager load(DrillTableKey key) {
                return key.getMetadataProviderManager();
            }
        });
        this.useRootSchema = useRootSchema;
    }

    void disallowTemporaryTables() {
        this.allowTemporaryTables = false;
    }

    public Prepare.PreparingTable getTable(List<String> names) {
        DrillTable drillTable;
        this.checkTemporaryTable(names);
        Prepare.PreparingTable table = super.getTable(names);
        if (table != null && (drillTable = (DrillTable)table.unwrap(DrillTable.class)) != null) {
            drillTable.setOptions(this.session.getOptions());
            drillTable.setTableMetadataProviderManager(this.tableCache.getUnchecked(DrillTableKey.of(names, drillTable)));
        }
        return table;
    }

    private void checkTemporaryTable(List<String> names) {
        if (this.allowTemporaryTables || !this.needsTemporaryTableCheck(names, this.session.getDefaultSchemaPath(), this.drillConfig)) {
            return;
        }
        String tableName = names.get(names.size() - 1);
        String originalTableName = this.session.resolveTemporaryTableName(tableName);
        if (originalTableName != null) {
            throw UserException.validationError().message("A reference to temporary table [%s] was made in a context where temporary table references are not allowed.", tableName).build(logger);
        }
    }

    public List<List<String>> getSchemaPaths() {
        if (this.useRootSchema.getAsBoolean()) {
            return ImmutableList.of(ImmutableList.of());
        }
        return super.getSchemaPaths();
    }

    private boolean needsTemporaryTableCheck(List<String> names, String defaultSchemaPath, DrillConfig drillConfig) {
        if (names.size() == 1) {
            return true;
        }
        String schemaPath = SchemaUtilities.getSchemaPath(names.subList(0, names.size() - 1));
        return SchemaUtilities.isTemporaryWorkspace(schemaPath, drillConfig) || SchemaUtilities.isTemporaryWorkspace(SchemaUtilities.SCHEMA_PATH_JOINER.join(defaultSchemaPath, schemaPath, new Object[0]), drillConfig);
    }

    private static CalciteConnectionConfigImpl getConnectionConfig(boolean caseSensitive) {
        Properties properties = new Properties();
        properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(caseSensitive));
        return new CalciteConnectionConfigImpl(properties);
    }
}

