/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.conversion;

import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.sql.conversion.DrillCalciteCatalogReader;
import org.apache.drill.exec.planner.sql.conversion.SqlConverter;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillViewExpander
implements RelOptTable.ViewExpander {
    private static final Logger logger = LoggerFactory.getLogger(DrillViewExpander.class);
    private final SqlConverter sqlConverter;

    public DrillViewExpander(SqlConverter sqlConverter) {
        this.sqlConverter = sqlConverter;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        DrillCalciteCatalogReader catalogReader = this.newCatalogReader(this.sqlConverter.getRootSchema(), schemaPath);
        SqlConverter parser = new SqlConverter(this.sqlConverter, this.sqlConverter.getDefaultSchema(), this.sqlConverter.getRootSchema(), catalogReader);
        return this.convertToRel(queryString, parser);
    }

    public RelRoot expandView(String queryString, SchemaPlus rootSchema, List<String> schemaPath) {
        DrillCalciteCatalogReader catalogReader = this.newCatalogReader(rootSchema, schemaPath);
        SchemaPlus schema = this.findSchema(queryString, rootSchema, schemaPath);
        SqlConverter parser = new SqlConverter(this.sqlConverter, schema, rootSchema, catalogReader);
        return this.convertToRel(queryString, parser);
    }

    private RelRoot convertToRel(String queryString, SqlConverter converter) {
        converter.disallowTemporaryTables();
        SqlNode parsedNode = converter.parse(queryString);
        SqlNode validatedNode = converter.validate(parsedNode);
        return converter.toRel(validatedNode);
    }

    private DrillCalciteCatalogReader newCatalogReader(SchemaPlus rootSchema, List<String> schemaPath) {
        return new DrillCalciteCatalogReader(rootSchema, this.sqlConverter.isCaseSensitive(), schemaPath, this.sqlConverter.getTypeFactory(), this.sqlConverter.getDrillConfig(), this.sqlConverter.getSession(), this.sqlConverter::useRootSchema);
    }

    private SchemaPlus findSchema(String queryString, SchemaPlus rootSchema, List<String> schemaPath) {
        SchemaPlus schema = rootSchema;
        for (String s : schemaPath) {
            SchemaPlus newSchema = schema.getSubSchema(s);
            if (newSchema == null) {
                throw UserException.validationError().message("Failure while attempting to expand view. Requested schema %s not available in schema %s.", s, schema.getName()).addContext("View Context", Joiner.on(", ").join(schemaPath)).addContext("View SQL", queryString).build(logger);
            }
            schema = newSchema;
        }
        return schema;
    }
}

