/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.planner.logical.DrillAnalyzeRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScreenRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillWriterRel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.SqlSelectBuilder;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DrillTableInfo;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.parser.SqlAnalyzeTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.NamedFormatPluginConfig;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeTableHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeTableHandler.class);

    public AnalyzeTableHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        super(config, textPlan);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        SqlAnalyzeTable sqlAnalyzeTable = AnalyzeTableHandler.unwrap(sqlNode, SqlAnalyzeTable.class);
        AnalyzeTableHandler.verifyNoUnsupportedFunctions(sqlAnalyzeTable);
        SqlNode tableRef = sqlAnalyzeTable.getTableRef();
        SqlSelect scanSql = new SqlSelectBuilder().parserPosition(SqlParserPos.ZERO).keywordList(SqlNodeList.EMPTY).selectList(this.getColumnList(sqlAnalyzeTable)).from(tableRef).build();
        DefaultSqlHandler.ConvertedRelNode convertedRelNode = this.validateAndConvert(this.rewrite((SqlNode)scanSql));
        RelDataType validatedRowType = convertedRelNode.getValidatedRowType();
        RelNode relScan = convertedRelNode.getConvertedNode();
        DrillTableInfo drillTableInfo = DrillTableInfo.getTableInfoHolder(sqlAnalyzeTable.getTableRef(), this.config);
        String tableName = drillTableInfo.tableName();
        AbstractSchema drillSchema = SchemaUtilities.resolveToDrillSchema(this.config.getConverter().getDefaultSchema(), drillTableInfo.schemaPath());
        Table table = SqlHandlerUtil.getTableFromSchema(drillSchema, tableName);
        if (table == null) {
            throw UserException.validationError().message("No table with given name [%s] exists in schema [%s]", tableName, drillSchema.getFullSchemaName()).build(logger);
        }
        if (!(table instanceof DrillTable)) {
            return DrillStatsTable.notSupported(this.context, tableName);
        }
        DrillTable drillTable = (DrillTable)table;
        Object selection = drillTable.getSelection();
        if (!(selection instanceof FormatSelection)) {
            return DrillStatsTable.notSupported(this.context, tableName);
        }
        FormatSelection formatSelection = (FormatSelection)selection;
        FormatPluginConfig formatConfig = formatSelection.getFormat();
        if (!(formatConfig instanceof ParquetFormatConfig || formatConfig instanceof NamedFormatPluginConfig && ((NamedFormatPluginConfig)formatConfig).getName().equals("parquet"))) {
            return DrillStatsTable.notSupported(this.context, tableName);
        }
        FileSystemPlugin plugin = (FileSystemPlugin)drillTable.getPlugin();
        DrillFileSystem fs = new DrillFileSystem(plugin.getFormatPlugin(formatSelection.getFormat()).getFsConf());
        Path selectionRoot = formatSelection.getSelection().getSelectionRoot();
        String tablePath = selectionRoot.toUri().getPath();
        boolean pathMatchesTableName = tablePath.endsWith(StringUtils.stripEnd((String)tableName, (String)"/"));
        if (!pathMatchesTableName || !fs.getFileStatus(selectionRoot).isDirectory()) {
            return DrillStatsTable.notSupported(this.context, tableName);
        }
        Path statsFilePath = new Path(selectionRoot, DotDrillType.STATS.getEnding());
        if (fs.exists(statsFilePath) && !this.isStatsStale(fs, statsFilePath)) {
            return DrillStatsTable.notRequired(this.context, tableName);
        }
        DrillRel drel = this.convertToDrel(relScan, drillSchema, tableName, sqlAnalyzeTable.getSamplePercent());
        Prel prel = this.convertToPrel(drel, validatedRowType);
        this.logAndSetTextPlan("Drill Physical", prel, logger);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop, relScan);
        this.log("Drill Plan", plan, logger);
        return plan;
    }

    private boolean isStatsStale(DrillFileSystem fs, Path statsFilePath) throws IOException {
        long statsFileModifyTime = fs.getFileStatus(statsFilePath).getModificationTime();
        Path parentPath = statsFilePath.getParent();
        FileStatus directoryStatus = fs.getFileStatus(parentPath);
        return directoryStatus.getModificationTime() > statsFileModifyTime || this.tableModified(fs, parentPath, statsFileModifyTime);
    }

    private boolean tableModified(DrillFileSystem fs, Path parentPath, long statsModificationTime) throws IOException {
        for (FileStatus file : fs.listStatus(parentPath)) {
            if (file.getModificationTime() > statsModificationTime) {
                return true;
            }
            if (!file.isDirectory() || !this.tableModified(fs, file.getPath(), statsModificationTime)) continue;
            return true;
        }
        return false;
    }

    private SqlNodeList getColumnList(SqlAnalyzeTable sqlAnalyzeTable) {
        SqlNodeList columnList = sqlAnalyzeTable.getFieldList();
        if (columnList == null || columnList.size() <= 0) {
            columnList = new SqlNodeList(SqlParserPos.ZERO);
            columnList.add((SqlNode)new SqlIdentifier(SchemaPath.STAR_COLUMN.rootName(), SqlParserPos.ZERO));
        }
        return columnList;
    }

    protected DrillRel convertToDrel(RelNode relNode, AbstractSchema schema, String analyzeTableName, double samplePercent) throws SqlUnsupportedException {
        DrillRel convertedRelNode = this.convertToRawDrel(relNode);
        DrillAnalyzeRel analyzeRel = new DrillAnalyzeRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, samplePercent);
        DrillWriterRel writerRel = new DrillWriterRel(analyzeRel.getCluster(), analyzeRel.getTraitSet(), analyzeRel, schema.appendToStatsTable(analyzeTableName));
        return new DrillScreenRel(writerRel.getCluster(), writerRel.getTraitSet(), writerRel);
    }

    private static void verifyNoUnsupportedFunctions(SqlAnalyzeTable analyzeTable) {
        if (analyzeTable.getEstimate()) {
            throw UserException.unsupportedError().message("Statistics estimation is not yet supported.", new Object[0]).build(logger);
        }
        if (analyzeTable.getSamplePercent() <= 0 && (double)analyzeTable.getSamplePercent() > 100.0) {
            throw UserException.unsupportedError().message("Valid sampling percent between 0-100 is not specified.", new Object[0]).build(logger);
        }
    }
}

