/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class ComplexUnnestVisitor
extends RelShuttleImpl {
    private static final String COMPLEX_FIELD_NAME = "$COMPLEX_FIELD_NAME";
    private final Map<CorrelationId, RelNode> leftInputs = new HashMap<CorrelationId, RelNode>();
    private final Map<CorrelationId, CorrelationId> updatedCorrelationIds = new HashMap<CorrelationId, CorrelationId>();

    private ComplexUnnestVisitor() {
    }

    public RelNode visit(LogicalCorrelate correlate) {
        RelNode left = correlate.getLeft().accept((RelShuttle)this);
        this.leftInputs.put(correlate.getCorrelationId(), left);
        RelNode right = correlate.getRight().accept((RelShuttle)this);
        if (correlate.getRight() == right || left == this.leftInputs.get(correlate.getCorrelationId())) {
            if (correlate.getLeft() == left) {
                return correlate;
            }
            return correlate.copy(correlate.getTraitSet(), Arrays.asList(left, right));
        }
        LogicalCorrelate newCorrelate = correlate.copy(correlate.getTraitSet(), this.leftInputs.get(correlate.getCorrelationId()), right, this.updatedCorrelationIds.get(correlate.getCorrelationId()), ImmutableBitSet.of((int[])new int[]{left.getRowType().getFieldCount()}), correlate.getJoinType());
        RelBuilder builder = DrillRelFactories.LOGICAL_BUILDER.create(correlate.getCluster(), null);
        builder.push((RelNode)newCorrelate);
        List topProjectExpressions = left.getRowType().getFieldList().stream().map(arg_0 -> ComplexUnnestVisitor.lambda$visit$0(builder, (Correlate)newCorrelate, arg_0)).collect(Collectors.toList());
        int rightStartIndex = left.getRowType().getFieldList().size() + 1;
        switch (correlate.getJoinType()) {
            case LEFT: 
            case INNER: {
                topProjectExpressions.addAll(right.getRowType().getFieldList().stream().map(arg_0 -> ComplexUnnestVisitor.lambda$visit$1(builder, (Correlate)newCorrelate, rightStartIndex, arg_0)).collect(Collectors.toList()));
            }
            case ANTI: 
            case SEMI: {
                builder.project(topProjectExpressions, (Iterable)correlate.getRowType().getFieldNames());
            }
        }
        return builder.build();
    }

    public RelNode visit(RelNode other) {
        if (other instanceof Uncollect) {
            return this.visit((Uncollect)other);
        }
        return super.visit(other);
    }

    public RelNode visit(Uncollect uncollect) {
        RelBuilder builder = DrillRelFactories.LOGICAL_BUILDER.create(uncollect.getCluster(), null);
        RexBuilder rexBuilder = builder.getRexBuilder();
        assert (uncollect.getInput() instanceof Project) : "Uncollect should have Project input";
        Project project = (Project)uncollect.getInput();
        List projectChildExps = project.getProjects();
        assert (projectChildExps.size() == 1) : "Uncollect does not support multiple expressions";
        RexNode projectExpr = (RexNode)projectChildExps.iterator().next();
        if (projectExpr.getKind() == SqlKind.FIELD_ACCESS) {
            return uncollect;
        }
        RelOptUtil.VariableUsedVisitor variableUsedVisitor = new RelOptUtil.VariableUsedVisitor(null);
        project.accept((RexShuttle)variableUsedVisitor);
        assert (variableUsedVisitor.variables.size() == 1) : "Uncollect supports only single correlated reference";
        CorrelationId oldCorrId = (CorrelationId)variableUsedVisitor.variables.iterator().next();
        RelNode left = this.leftInputs.get(oldCorrId);
        ArrayList<Object> leftProjExprs = new ArrayList<Object>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (RelDataTypeField field : left.getRowType().getFieldList()) {
            leftProjExprs.add(rexBuilder.makeInputRef(left, field.getIndex()));
            fieldNames.add(field.getName());
        }
        fieldNames.add(COMPLEX_FIELD_NAME);
        builder.push(left);
        leftProjExprs.add(new RexFieldAccessReplacer(builder).apply(projectExpr));
        RelNode leftProject = builder.project(leftProjExprs, fieldNames).build();
        this.leftInputs.put(oldCorrId, leftProject);
        builder.push(project.getInput());
        CorrelationId newCorrId = uncollect.getCluster().createCorrel();
        this.updatedCorrelationIds.put(oldCorrId, newCorrId);
        RexNode rexCorrel = rexBuilder.makeCorrel(leftProject.getRowType(), newCorrId);
        builder.project(ImmutableList.of(rexBuilder.makeFieldAccess(rexCorrel, leftProjExprs.size() - 1)), ImmutableList.of(COMPLEX_FIELD_NAME));
        return uncollect.copy(uncollect.getTraitSet(), builder.build());
    }

    public static RelNode rewriteUnnestWithComplexExprs(RelNode relNode) {
        ComplexUnnestVisitor visitor = new ComplexUnnestVisitor();
        return relNode.accept((RelShuttle)visitor);
    }

    private static /* synthetic */ RexInputRef lambda$visit$1(RelBuilder builder, Correlate newCorrelate, int rightStartIndex, RelDataTypeField field) {
        return builder.getRexBuilder().makeInputRef((RelNode)newCorrelate, field.getIndex() + rightStartIndex);
    }

    private static /* synthetic */ RexInputRef lambda$visit$0(RelBuilder builder, Correlate newCorrelate, RelDataTypeField field) {
        return builder.getRexBuilder().makeInputRef((RelNode)newCorrelate, field.getIndex());
    }

    private static class RexFieldAccessReplacer
    extends RexShuttle {
        private final RelBuilder builder;

        public RexFieldAccessReplacer(RelBuilder builder) {
            this.builder = builder;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.builder.field(fieldAccess.getField().getName());
        }
    }
}

