/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.AliasTarget;
import org.apache.drill.exec.alias.Aliases;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.BaseAliasHandler;
import org.apache.drill.exec.planner.sql.handlers.DrillTableInfo;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlCreateAlias;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAliasHandler
extends BaseAliasHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateAliasHandler.class);

    public CreateAliasHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException, IOException {
        this.checkAliasesEnabled();
        SqlCreateAlias node = CreateAliasHandler.unwrap(sqlNode, SqlCreateAlias.class);
        String alias = SchemaPath.getCompoundPath(node.getAlias().names.toArray(new String[0])).toExpr();
        String aliasTarget = ((SqlLiteral)node.getAliasKind()).toValue();
        AliasRegistry aliasRegistry = this.getAliasRegistry(aliasTarget);
        String value = this.getValue(node, aliasTarget);
        boolean replace = ((SqlLiteral)node.getReplace()).booleanValue();
        Aliases aliases = this.getAliases(node, aliasRegistry);
        if (!aliases.put(alias, value, replace)) {
            throw UserException.validationError().message("Alias with given name [%s] already exists", alias).build(logger);
        }
        return DirectPlan.createDirectPlan(this.context, true, String.format("%s alias '%s' for '%s' created successfully", StringUtils.capitalize((String)aliasTarget.toLowerCase(Locale.ROOT)), alias, value));
    }

    private String getValue(SqlCreateAlias node, String aliasTarget) {
        switch (AliasTarget.valueOf(aliasTarget)) {
            case TABLE: {
                return this.getTableQualifier((SqlNode)node.getSource());
            }
            case STORAGE: {
                return this.getStorageQualifier(node.getSource().names);
            }
        }
        throw UserException.validationError().message("Unsupported alias target: [%s]", aliasTarget).build(logger);
    }

    private String getStorageQualifier(List<String> path) {
        SchemaUtilities.resolveToDrillSchema(this.config.getConverter().getDefaultSchema(), path);
        if (path.size() > 1) {
            throw UserException.validationError().message("Storage name expected, but provided [%s]", SchemaUtilities.getSchemaPath(path)).build(logger);
        }
        return SchemaPath.getCompoundPath(path.get(0)).toExpr();
    }

    private String getTableQualifier(SqlNode tableRef) {
        DrillTableInfo drillTableInfo = DrillTableInfo.getTableInfoHolder(tableRef, this.config);
        if (drillTableInfo.drillTable() == null) {
            throw UserException.validationError().message("No table with given name [%s] exists in schema [%s]", drillTableInfo.tableName(), SchemaUtilities.getSchemaPath(drillTableInfo.schemaPath())).build(logger);
        }
        String[] paths = new String[drillTableInfo.schemaPath().size() + 1];
        System.arraycopy(drillTableInfo.schemaPath().toArray(new String[0]), 0, paths, 0, drillTableInfo.schemaPath().size());
        paths[drillTableInfo.schemaPath().size()] = drillTableInfo.tableName();
        return SchemaPath.getCompoundPath(paths).toExpr();
    }

    private Aliases getAliases(SqlCreateAlias node, AliasRegistry aliasRegistry) {
        return ((SqlLiteral)node.getIsPublic()).booleanValue() ? this.getPublicAliases(node, aliasRegistry) : this.getUserAliases(node, aliasRegistry);
    }

    private Aliases getUserAliases(SqlCreateAlias node, AliasRegistry aliasRegistry) {
        if (!this.context.isImpersonationEnabled()) {
            throw UserException.validationError().message("Cannot create user alias when user impersonation is disabled", new Object[0]).build(logger);
        }
        String userName = this.resolveUserName(node.getUser());
        aliasRegistry.createUserAliases(userName);
        return aliasRegistry.getUserAliases(userName);
    }

    private Aliases getPublicAliases(SqlCreateAlias node, AliasRegistry aliasRegistry) {
        if (node.getUser() != null) {
            throw UserException.validationError().message("Cannot create public alias for specific user", new Object[0]).build(logger);
        }
        this.checkAdminPrivileges(this.context.getOptions());
        aliasRegistry.createPublicAliases();
        return aliasRegistry.getPublicAliases();
    }
}

