/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.io.FileUtils;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.exception.FunctionValidationException;
import org.apache.drill.exec.exception.JarValidationException;
import org.apache.drill.exec.exception.VersionMismatchException;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.registry.RemoteFunctionRegistry;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlCreateFunction;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;
import org.apache.drill.exec.util.JarUtil;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFunctionHandler
extends DefaultSqlHandler {
    private static Logger logger = LoggerFactory.getLogger(CreateFunctionHandler.class);

    public CreateFunctionHandler(SqlHandlerConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException, IOException {
        if (!this.context.getOption((String)"exec.udf.enable_dynamic_support").bool_val.booleanValue()) {
            throw UserException.validationError().message("Dynamic UDFs support is disabled.", new Object[0]).build(logger);
        }
        RemoteFunctionRegistry remoteRegistry = this.context.getRemoteFunctionRegistry();
        JarManager jarManager = new JarManager(sqlNode, remoteRegistry);
        boolean inProgress = false;
        try {
            String action = remoteRegistry.addToJars(jarManager.getBinaryName(), RemoteFunctionRegistry.Action.REGISTRATION);
            inProgress = action == null;
            if (!inProgress) {
                PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, false, String.format("Jar with %s name is used. Action: %s", jarManager.getBinaryName(), action));
                return physicalPlan;
            }
            jarManager.initRemoteBackup();
            List<String> functions = this.validateAgainstLocalRegistry(jarManager, this.context.getFunctionRegistry());
            this.initRemoteRegistration(functions, jarManager, remoteRegistry);
            jarManager.deleteQuietlyFromStagingArea();
            PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, true, String.format("The following UDFs in jar %s have been registered:\n%s", jarManager.getBinaryName(), functions));
            return physicalPlan;
        }
        catch (Exception e) {
            logger.error("Error during UDF registration", (Throwable)e);
            PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, false, e.getMessage());
            return physicalPlan;
        }
        finally {
            if (inProgress) {
                remoteRegistry.removeFromJars(jarManager.getBinaryName());
            }
            jarManager.cleanUp();
        }
    }

    private List<String> validateAgainstLocalRegistry(JarManager jarManager, FunctionImplementationRegistry localFunctionRegistry) throws IOException {
        Path localBinary = jarManager.copyBinaryToLocal();
        return localFunctionRegistry.validate(localBinary);
    }

    private void validateAgainstRemoteRegistry(List<UserBitShared.Jar> remoteJars, String jarName, List<String> functions) {
        for (UserBitShared.Jar remoteJar : remoteJars) {
            if (remoteJar.getName().equals(jarName)) {
                throw new JarValidationException(String.format("Jar with %s name has been already registered", jarName));
            }
            for (String remoteFunction : remoteJar.getFunctionSignatureList()) {
                for (String func : functions) {
                    if (!remoteFunction.equals(func)) continue;
                    throw new FunctionValidationException(String.format("Found duplicated function in %s: %s", remoteJar.getName(), remoteFunction));
                }
            }
        }
    }

    private void initRemoteRegistration(List<String> functions, JarManager jarManager, RemoteFunctionRegistry remoteRegistry) throws IOException {
        boolean copyJars = true;
        try {
            for (int retryAttempts = remoteRegistry.getRetryAttempts(); retryAttempts >= 0; --retryAttempts) {
                DataChangeVersion version = new DataChangeVersion();
                List<UserBitShared.Jar> remoteJars = remoteRegistry.getRegistry(version).getJarList();
                this.validateAgainstRemoteRegistry(remoteJars, jarManager.getBinaryName(), functions);
                if (copyJars) {
                    jarManager.copyToRegistryArea();
                    copyJars = false;
                }
                ArrayList<UserBitShared.Jar> jars = Lists.newArrayList(remoteJars);
                jars.add(UserBitShared.Jar.newBuilder().setName(jarManager.getBinaryName()).addAllFunctionSignature(functions).build());
                UserBitShared.Registry updatedRegistry = UserBitShared.Registry.newBuilder().addAllJar(jars).build();
                try {
                    remoteRegistry.updateRegistry(updatedRegistry, version);
                    return;
                }
                catch (VersionMismatchException ex) {
                    logger.debug("Failed to update function registry during registration, version mismatch was detected.", (Throwable)ex);
                    continue;
                }
            }
            throw new DrillRuntimeException("Failed to update remote function registry. Exceeded retry attempts limit.");
        }
        catch (Exception e) {
            if (!copyJars) {
                jarManager.deleteQuietlyFromRegistryArea();
            }
            throw e;
        }
    }

    private class JarManager {
        private final String binaryName;
        private final FileSystem fs;
        private final Path remoteTmpDir;
        private final Path localTmpDir;
        private final Path stagingBinary;
        private final Path stagingSource;
        private final Path tmpRemoteBinary;
        private final Path tmpRemoteSource;
        private final Path registryBinary;
        private final Path registrySource;

        JarManager(SqlNode sqlNode, RemoteFunctionRegistry remoteRegistry) throws ForemanSetupException {
            SqlCreateFunction node = AbstractSqlHandler.unwrap(sqlNode, SqlCreateFunction.class);
            this.binaryName = ((SqlCharStringLiteral)node.getJar()).toValue();
            String sourceName = JarUtil.getSourceName(this.binaryName);
            this.stagingBinary = new Path(remoteRegistry.getStagingArea(), this.binaryName);
            this.stagingSource = new Path(remoteRegistry.getStagingArea(), sourceName);
            this.remoteTmpDir = new Path(remoteRegistry.getTmpArea(), UUID.randomUUID().toString());
            this.tmpRemoteBinary = new Path(this.remoteTmpDir, this.binaryName);
            this.tmpRemoteSource = new Path(this.remoteTmpDir, sourceName);
            this.registryBinary = new Path(remoteRegistry.getRegistryArea(), this.binaryName);
            this.registrySource = new Path(remoteRegistry.getRegistryArea(), sourceName);
            this.localTmpDir = new Path(DrillFileUtils.createTempDir().toURI());
            this.fs = remoteRegistry.getFs();
        }

        String getBinaryName() {
            return this.binaryName;
        }

        void initRemoteBackup() throws IOException {
            this.checkPathExistence(this.stagingBinary);
            this.checkPathExistence(this.stagingSource);
            this.fs.mkdirs(this.remoteTmpDir);
            FileUtil.copy((FileSystem)this.fs, (Path)this.stagingBinary, (FileSystem)this.fs, (Path)this.tmpRemoteBinary, (boolean)false, (boolean)true, (Configuration)this.fs.getConf());
            FileUtil.copy((FileSystem)this.fs, (Path)this.stagingSource, (FileSystem)this.fs, (Path)this.tmpRemoteSource, (boolean)false, (boolean)true, (Configuration)this.fs.getConf());
        }

        Path copyBinaryToLocal() throws IOException {
            Path localBinary = new Path(this.localTmpDir, this.binaryName);
            this.fs.copyToLocalFile(this.tmpRemoteBinary, localBinary);
            return localBinary;
        }

        void copyToRegistryArea() throws IOException {
            FileUtil.copy((FileSystem)this.fs, (Path)this.tmpRemoteBinary, (FileSystem)this.fs, (Path)this.registryBinary, (boolean)false, (boolean)true, (Configuration)this.fs.getConf());
            try {
                FileUtil.copy((FileSystem)this.fs, (Path)this.tmpRemoteSource, (FileSystem)this.fs, (Path)this.registrySource, (boolean)false, (boolean)true, (Configuration)this.fs.getConf());
            }
            catch (IOException e) {
                this.deleteQuietly(this.registryBinary, false);
                throw new IOException(e);
            }
        }

        void deleteQuietlyFromStagingArea() {
            this.deleteQuietly(this.stagingBinary, false);
            this.deleteQuietly(this.stagingSource, false);
        }

        void deleteQuietlyFromRegistryArea() {
            this.deleteQuietly(this.registryBinary, false);
            this.deleteQuietly(this.registrySource, false);
        }

        void cleanUp() {
            FileUtils.deleteQuietly((File)new File(this.localTmpDir.toUri()));
            this.deleteQuietly(this.remoteTmpDir, true);
        }

        private void checkPathExistence(Path path) throws IOException {
            if (!this.fs.exists(path)) {
                throw new IOException(String.format("File %s does not exist on file system %s", path.toUri().getPath(), this.fs.getUri()));
            }
        }

        private void deleteQuietly(Path path, boolean isDirectory) {
            try {
                this.fs.delete(path, isDirectory);
            }
            catch (IOException e) {
                logger.warn(String.format("Error during deletion [%s]", path.toUri().getPath()), (Throwable)e);
            }
        }
    }
}

