/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.planner.PlannerType;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScreenRel;
import org.apache.drill.exec.planner.logical.PreProcessLogicalRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.exec.planner.physical.visitor.AdjustOperatorsSchemaVisitor;
import org.apache.drill.exec.planner.physical.visitor.ComplexToJsonPrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.ExcessiveExchangeIdentifier;
import org.apache.drill.exec.planner.physical.visitor.FinalColumnReorderer;
import org.apache.drill.exec.planner.physical.visitor.InsertLocalExchangeVisitor;
import org.apache.drill.exec.planner.physical.visitor.LateralUnnestRowIDVisitor;
import org.apache.drill.exec.planner.physical.visitor.MemoryEstimationVisitor;
import org.apache.drill.exec.planner.physical.visitor.RelUniqifier;
import org.apache.drill.exec.planner.physical.visitor.RewriteProjectToFlatten;
import org.apache.drill.exec.planner.physical.visitor.RuntimeFilterVisitor;
import org.apache.drill.exec.planner.physical.visitor.SelectionVectorPrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.SplitUpComplexExpressions;
import org.apache.drill.exec.planner.physical.visitor.StarColumnConverter;
import org.apache.drill.exec.planner.physical.visitor.SwapHashJoinVisitor;
import org.apache.drill.exec.planner.physical.visitor.TopProjectVisitor;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ComplexUnnestVisitor;
import org.apache.drill.exec.planner.sql.handlers.FindHardDistributionScans;
import org.apache.drill.exec.planner.sql.handlers.FindLimit0Visitor;
import org.apache.drill.exec.planner.sql.handlers.PrelFinalizable;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.FindLimit0SqlVisitor;
import org.apache.drill.exec.planner.sql.parser.UnsupportedOperatorsVisitor;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlHandler
extends AbstractSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSqlHandler.class);
    private final Pointer<String> textPlan;
    private final long targetSliceSize;
    protected final SqlHandlerConfig config;
    protected final QueryContext context;

    public DefaultSqlHandler(SqlHandlerConfig config) {
        this(config, null);
    }

    public DefaultSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        this.config = config;
        this.context = config.getContext();
        this.textPlan = textPlan;
        this.targetSliceSize = config.getContext().getOptions().getOption(ExecConstants.SLICE_TARGET_OPTION);
    }

    protected void log(PlannerType plannerType, PlannerPhase phase, RelNode node, Logger logger, Stopwatch watch) {
        if (logger.isDebugEnabled()) {
            this.log(plannerType.name() + ":" + phase.description, node, logger, watch);
        }
    }

    protected void log(String description, RelNode node, Logger logger, Stopwatch watch) {
        if (logger.isDebugEnabled()) {
            String plan = RelOptUtil.toString((RelNode)node, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
            String time = watch == null ? "" : String.format(" (%dms)", watch.elapsed(TimeUnit.MILLISECONDS));
            logger.debug(String.format("%s%s:\n%s", description, time, plan));
        }
    }

    protected void logAndSetTextPlan(String description, Prel prel, Logger logger) {
        String plan = PrelSequencer.printWithIds(prel, SqlExplainLevel.ALL_ATTRIBUTES);
        if (this.textPlan != null) {
            this.textPlan.value = plan;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("%s:\n%s", description, plan));
        }
    }

    protected void log(String name, PhysicalPlan plan, Logger logger) {
        if (logger.isDebugEnabled()) {
            SimpleBeanPropertyFilter.SerializeExceptFilter filter = new SimpleBeanPropertyFilter.SerializeExceptFilter(Sets.newHashSet("password"));
            String planText = plan.unparse(this.context.getLpPersistence().getMapper().writer((FilterProvider)new SimpleFilterProvider().addFilter("passwordFilter", (PropertyFilter)filter)));
            logger.debug(name + " : \n" + planText);
        }
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        ConvertedRelNode convertedRelNode = this.validateAndConvert(sqlNode);
        RelDataType validatedRowType = convertedRelNode.getValidatedRowType();
        RelNode queryRelNode = convertedRelNode.getConvertedNode();
        DrillRel drel = this.convertToDrel(queryRelNode);
        Prel prel = this.convertToPrel(drel, validatedRowType);
        this.logAndSetTextPlan("Drill Physical", prel, logger);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop, queryRelNode);
        this.log("Drill Plan", plan, logger);
        return plan;
    }

    protected SqlNode rewrite(SqlNode node) throws RelConversionException, ForemanSetupException {
        return node;
    }

    protected ConvertedRelNode validateAndConvert(SqlNode sqlNode) throws ForemanSetupException, RelConversionException, ValidationException {
        SqlNode rewrittenSqlNode = this.rewrite(sqlNode);
        Pair<SqlNode, RelDataType> validatedTypedSqlNode = this.validateNode(rewrittenSqlNode);
        SqlNode validated = (SqlNode)validatedTypedSqlNode.getKey();
        RelNode rel = this.convertToRel(validated);
        rel = this.preprocessNode(rel);
        return new ConvertedRelNode(rel, (RelDataType)validatedTypedSqlNode.getValue());
    }

    protected DrillRel convertToRawDrel(RelNode relNode) throws SqlUnsupportedException {
        if (this.context.getOptions().getOption(ExecConstants.EARLY_LIMIT0_OPT) && this.context.getPlannerSettings().isTypeInferenceEnabled() && FindLimit0Visitor.containsLimit0(relNode)) {
            DrillRel shorterPlan = FindLimit0Visitor.getDirectScanRelIfFullySchemaed(relNode);
            if (shorterPlan != null) {
                return shorterPlan;
            }
            if (FindHardDistributionScans.canForceSingleMode(relNode)) {
                this.context.getPlannerSettings().forceSingleMode();
            }
        }
        try {
            RelNode convertedRelNode;
            RelNode pruned = this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.DIRECTORY_PRUNING, relNode);
            RelTraitSet logicalTraits = pruned.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
            if (!this.context.getPlannerSettings().isHepOptEnabled()) {
                convertedRelNode = this.transform(PlannerType.VOLCANO, PlannerPhase.LOGICAL_PRUNE_AND_JOIN, pruned, logicalTraits);
            } else {
                RelNode intermediateNode2;
                if (this.context.getPlannerSettings().isHepPartitionPruningEnabled()) {
                    RelNode intermediateNode = this.transform(PlannerType.VOLCANO, PlannerPhase.LOGICAL, pruned, logicalTraits);
                    RelNode transitiveClosureNode = this.transform(PlannerType.HEP, PlannerPhase.TRANSITIVE_CLOSURE, intermediateNode);
                    intermediateNode2 = this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.PARTITION_PRUNING, transitiveClosureNode);
                } else {
                    RelNode intermediateNode = this.transform(PlannerType.VOLCANO, PlannerPhase.LOGICAL_PRUNE, pruned, logicalTraits);
                    intermediateNode2 = this.transform(PlannerType.HEP, PlannerPhase.TRANSITIVE_CLOSURE, intermediateNode);
                }
                RelNode intermediateNode3 = this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.JOIN_PLANNING, intermediateNode2);
                convertedRelNode = this.context.getPlannerSettings().isRowKeyJoinConversionEnabled() ? this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.ROWKEYJOIN_CONVERSION, intermediateNode3) : intermediateNode3;
            }
            RelNode convertedRelNodeWithSum0 = this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.SUM_CONVERSION, convertedRelNode);
            DrillRel drillRel = (DrillRel)convertedRelNodeWithSum0;
            if (FindLimit0Visitor.containsLimit0(convertedRelNodeWithSum0) && FindHardDistributionScans.canForceSingleMode(convertedRelNodeWithSum0)) {
                this.context.getPlannerSettings().forceSingleMode();
                if (this.context.getOptions().getOption(ExecConstants.LATE_LIMIT0_OPT)) {
                    drillRel = FindLimit0Visitor.addLimitOnTopOfLeafNodes(drillRel);
                }
            }
            return drillRel;
        }
        catch (RelOptPlanner.CannotPlanException ex) {
            logger.error(ex.getMessage());
            if (JoinUtils.checkCartesianJoin(relNode)) {
                throw JoinUtils.cartesianJoinPlanningException();
            }
            throw ex;
        }
    }

    protected DrillRel convertToDrel(RelNode relNode) throws SqlUnsupportedException {
        DrillRel convertedRelNode = this.convertToRawDrel(relNode);
        return new DrillScreenRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode);
    }

    private RelNode transform(PlannerType plannerType, PlannerPhase phase, RelNode input) {
        return this.transform(plannerType, phase, input, input.getTraitSet());
    }

    protected RelNode transform(PlannerType plannerType, PlannerPhase phase, RelNode input, RelTraitSet targetTraits) {
        return this.transform(plannerType, phase, input, targetTraits, true);
    }

    protected RelNode transform(PlannerType plannerType, PlannerPhase phase, RelNode input, RelTraitSet targetTraits, boolean log) {
        RelNode output;
        Stopwatch watch = Stopwatch.createStarted();
        RuleSet rules = this.config.getRules(phase, input);
        RelTraitSet toTraits = targetTraits.simplify();
        switch (plannerType) {
            case HEP_BOTTOM_UP: 
            case HEP: {
                HepProgramBuilder hepPgmBldr = new HepProgramBuilder();
                if (plannerType == PlannerType.HEP_BOTTOM_UP) {
                    hepPgmBldr.addMatchOrder(HepMatchOrder.BOTTOM_UP);
                }
                for (RelOptRule rule : rules) {
                    hepPgmBldr.addRuleInstance(rule);
                }
                HepPlanner planner = new HepPlanner(hepPgmBldr.build(), (Context)this.context.getPlannerSettings(), true, null, RelOptCostImpl.FACTORY);
                JaninoRelMetadataProvider relMetadataProvider = Utilities.registerJaninoRelMetadataProvider();
                input.accept((RelShuttle)new MetaDataProviderModifier((RelMetadataProvider)relMetadataProvider));
                planner.setRoot(input);
                if (!input.getTraitSet().equals((Object)targetTraits)) {
                    planner.changeTraits(input, toTraits);
                }
                output = planner.findBestExp();
                break;
            }
            default: {
                RelOptPlanner planner = input.getCluster().getPlanner();
                Program program = Programs.of((RuleSet)rules);
                Preconditions.checkArgument(planner instanceof VolcanoPlanner, "Cluster is expected to be constructed using VolcanoPlanner. Was actually of type %s.", (Object)planner.getClass().getName());
                output = program.run(planner, input, toTraits, ImmutableList.of(), ImmutableList.of());
                break;
            }
        }
        if (log) {
            this.log(plannerType, phase, output, logger, watch);
        }
        return output;
    }

    protected Prel convertToPrel(RelNode drel, RelDataType validatedRowType) throws RelConversionException, SqlUnsupportedException {
        Prel phyRelNode;
        RelNode relNode;
        Preconditions.checkArgument(drel.getConvention() == DrillRel.DRILL_LOGICAL);
        RelTraitSet traits = drel.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON);
        try {
            Stopwatch watch = Stopwatch.createStarted();
            relNode = this.transform(PlannerType.VOLCANO, PlannerPhase.PHYSICAL, drel, traits, false);
            phyRelNode = (Prel)relNode.accept((RelShuttle)new PrelFinalizer());
            this.log(PlannerType.VOLCANO, PlannerPhase.PHYSICAL, phyRelNode, logger, watch);
        }
        catch (RelOptPlanner.CannotPlanException ex) {
            logger.error(ex.getMessage());
            if (JoinUtils.checkCartesianJoin(drel)) {
                throw JoinUtils.cartesianJoinPlanningException();
            }
            throw ex;
        }
        QueryOptionManager queryOptions = this.context.getOptions();
        if (this.context.getPlannerSettings().isMemoryEstimationEnabled() && !MemoryEstimationVisitor.enoughMemory(phyRelNode, queryOptions, this.context.getActiveEndpoints().size())) {
            this.log("Not enough memory for this plan", phyRelNode, logger, null);
            logger.debug("Re-planning without hash operations.");
            queryOptions.setLocalOption(PlannerSettings.HASHJOIN.getOptionName(), false);
            queryOptions.setLocalOption(PlannerSettings.HASHAGG.getOptionName(), false);
            try {
                relNode = this.transform(PlannerType.VOLCANO, PlannerPhase.PHYSICAL, drel, traits);
                phyRelNode = (Prel)relNode.accept((RelShuttle)new PrelFinalizer());
            }
            catch (RelOptPlanner.CannotPlanException ex) {
                logger.error(ex.getMessage());
                if (JoinUtils.checkCartesianJoin(drel)) {
                    throw JoinUtils.cartesianJoinPlanningException();
                }
                throw ex;
            }
        }
        phyRelNode = TopProjectVisitor.insertTopProject(phyRelNode, validatedRowType);
        phyRelNode = StarColumnConverter.insertRenameProject(phyRelNode);
        this.log("Physical RelNode after Top and Rename Project inserting: ", phyRelNode, logger, null);
        phyRelNode = AdjustOperatorsSchemaVisitor.adjustSchema(phyRelNode);
        if (this.context.getPlannerSettings().isHashJoinSwapEnabled()) {
            phyRelNode = SwapHashJoinVisitor.swapHashJoin(phyRelNode, this.context.getPlannerSettings().getHashJoinSwapMarginFactor());
        }
        if (this.context.getPlannerSettings().isParquetRowGroupFilterPushdownPlanningEnabled()) {
            phyRelNode = (Prel)this.transform(PlannerType.HEP_BOTTOM_UP, PlannerPhase.PHYSICAL_PARTITION_PRUNING, phyRelNode);
        }
        phyRelNode = phyRelNode.accept(new SplitUpComplexExpressions((RelDataTypeFactory)this.config.getConverter().getTypeFactory(), this.context.getPlannerSettings().functionImplementationRegistry, phyRelNode.getCluster().getRexBuilder()), null);
        phyRelNode = phyRelNode.accept(new RewriteProjectToFlatten((RelDataTypeFactory)this.config.getConverter().getTypeFactory(), this.context.getDrillOperatorTable()), null);
        phyRelNode = FinalColumnReorderer.addFinalColumnOrdering(phyRelNode);
        phyRelNode = ExcessiveExchangeIdentifier.removeExcessiveExchanges(phyRelNode, this.targetSliceSize);
        phyRelNode = LateralUnnestRowIDVisitor.insertRowID(phyRelNode);
        if (!this.context.getSession().isSupportComplexTypes()) {
            logger.debug("Client does not support complex types, add ComplexToJson operator.");
            phyRelNode = ComplexToJsonPrelVisitor.addComplexToJsonPrel(phyRelNode);
        }
        phyRelNode = InsertLocalExchangeVisitor.insertLocalExchanges(phyRelNode, queryOptions);
        if (this.context.isRuntimeFilterEnabled()) {
            phyRelNode = RuntimeFilterVisitor.addRuntimeFilter(phyRelNode, this.context);
        }
        phyRelNode = SelectionVectorPrelVisitor.addSelectionRemoversWhereNecessary(phyRelNode);
        phyRelNode = TopProjectVisitor.insertTopProject(phyRelNode, validatedRowType);
        phyRelNode = RelUniqifier.uniqifyGraph(phyRelNode);
        return phyRelNode;
    }

    protected PhysicalOperator convertToPop(Prel prel) throws IOException {
        PhysicalPlanCreator creator = new PhysicalPlanCreator(this.context, PrelSequencer.getIdMap(prel));
        PhysicalOperator op = prel.getPhysicalOperator(creator);
        return op;
    }

    protected PhysicalPlan convertToPlan(PhysicalOperator op, RelNode queryRelNode) {
        List<String> scannedPluginNames = this.config.getScannedPlugins(queryRelNode).stream().map(StoragePlugin::getName).collect(Collectors.toList());
        PlanProperties.PlanPropertiesBuilder propsBuilder = PlanProperties.builder();
        propsBuilder.type(PlanProperties.PlanType.APACHE_DRILL_PHYSICAL);
        propsBuilder.version(1);
        propsBuilder.options(new JSONOptions(this.context.getOptions().getOptionList()));
        propsBuilder.resultMode(PlanProperties.Generator.ResultMode.EXEC);
        propsBuilder.generator(this.getClass().getSimpleName(), "");
        propsBuilder.scannedPluginNames(scannedPluginNames);
        PhysicalPlan plan = new PhysicalPlan(propsBuilder.build(), DefaultSqlHandler.getPops(op));
        return plan;
    }

    public static List<PhysicalOperator> getPops(PhysicalOperator root) {
        ArrayList<PhysicalOperator> ops = Lists.newArrayList();
        PopCollector c = new PopCollector();
        root.accept(c, ops);
        return ops;
    }

    protected Pair<SqlNode, RelDataType> validateNode(SqlNode sqlNode) throws ValidationException, RelConversionException, ForemanSetupException {
        boolean rootSelectLimit0 = FindLimit0SqlVisitor.containsLimit0(sqlNode);
        this.context.getOptions().setLocalOption("planner.enable_file_listing_limit0_optimization", rootSelectLimit0);
        SqlNode sqlNodeValidated = this.config.getConverter().validate(sqlNode);
        Pair typedSqlNode = new Pair((Object)sqlNodeValidated, (Object)this.config.getConverter().getOutputType(sqlNodeValidated));
        UnsupportedOperatorsVisitor visitor = UnsupportedOperatorsVisitor.createVisitor(this.context);
        try {
            sqlNodeValidated.accept((SqlVisitor)visitor);
        }
        catch (UnsupportedOperationException ex) {
            visitor.convertException();
            throw ex;
        }
        return typedSqlNode;
    }

    private RelNode convertToRel(SqlNode node) {
        RelNode convertedNode = this.config.getConverter().toRel((SqlNode)node).rel;
        this.log("INITIAL", convertedNode, logger, null);
        RelNode transformedNode = this.transform(PlannerType.HEP, PlannerPhase.SUBQUERY_REWRITE, convertedNode);
        RelNode decorrelatedNode = RelDecorrelator.decorrelateQuery((RelNode)transformedNode, (RelBuilder)DrillRelFactories.LOGICAL_BUILDER.create(transformedNode.getCluster(), null));
        return this.transform(PlannerType.HEP, PlannerPhase.WINDOW_REWRITE, decorrelatedNode);
    }

    private RelNode preprocessNode(RelNode rel) throws SqlUnsupportedException {
        PreProcessLogicalRel visitor = PreProcessLogicalRel.createVisitor((RelDataTypeFactory)this.config.getConverter().getTypeFactory(), this.context.getDrillOperatorTable(), rel.getCluster().getRexBuilder());
        try {
            rel = rel.accept((RelShuttle)visitor);
        }
        catch (UnsupportedOperationException ex) {
            visitor.convertException();
            throw ex;
        }
        return ComplexUnnestVisitor.rewriteUnnestWithComplexExprs(rel);
    }

    protected DrillRel addRenamedProject(DrillRel rel, RelDataType validatedRowType) {
        RelDataType t = rel.getRowType();
        RexBuilder b = rel.getCluster().getRexBuilder();
        ArrayList<RexInputRef> projections = Lists.newArrayList();
        int projectCount = t.getFieldList().size();
        for (int i = 0; i < projectCount; ++i) {
            projections.add(b.makeInputRef((RelNode)rel, i));
        }
        List fieldNames2 = SqlValidatorUtil.uniquify((List)validatedRowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)rel.getCluster().getTypeFactory().getTypeSystem().isSchemaCaseSensitive());
        RelDataType newRowType = RexUtil.createStructType((RelDataTypeFactory)rel.getCluster().getTypeFactory(), projections, (List)fieldNames2, null);
        DrillProjectRel topProj = DrillProjectRel.create(rel.getCluster(), rel.getTraitSet(), rel, projections, newRowType);
        if (rel instanceof Project && DrillRelOptUtil.isTrivialProject(topProj, true)) {
            return rel;
        }
        return topProj;
    }

    protected class ConvertedRelNode {
        private final RelNode relNode;
        private final RelDataType validatedRowType;

        public ConvertedRelNode(RelNode relNode, RelDataType validatedRowType) {
            this.relNode = relNode;
            this.validatedRowType = validatedRowType;
        }

        public RelNode getConvertedNode() {
            return this.relNode;
        }

        public RelDataType getValidatedRowType() {
            return this.validatedRowType;
        }
    }

    public static class MetaDataProviderModifier
    extends RelShuttleImpl {
        private final RelMetadataProvider metadataProvider;

        public MetaDataProviderModifier(RelMetadataProvider metadataProvider) {
            this.metadataProvider = metadataProvider;
        }

        public RelNode visit(TableScan scan) {
            scan.getCluster().setMetadataProvider(this.metadataProvider);
            return super.visit(scan);
        }

        public RelNode visit(TableFunctionScan scan) {
            scan.getCluster().setMetadataProvider(this.metadataProvider);
            return super.visit(scan);
        }

        public RelNode visit(LogicalValues values) {
            values.getCluster().setMetadataProvider(this.metadataProvider);
            return super.visit(values);
        }

        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            child.accept((RelShuttle)this);
            parent.getCluster().setMetadataProvider(this.metadataProvider);
            return parent;
        }
    }

    private static class PrelFinalizer
    extends RelShuttleImpl {
        private PrelFinalizer() {
        }

        public RelNode visit(RelNode other) {
            if (other instanceof PrelFinalizable) {
                return ((PrelFinalizable)other).finalizeRel();
            }
            return super.visit(other);
        }
    }

    private static class PopCollector
    extends AbstractPhysicalVisitor<Void, Collection<PhysicalOperator>, RuntimeException> {
        private PopCollector() {
        }

        @Override
        public Void visitOp(PhysicalOperator op, Collection<PhysicalOperator> collection) throws RuntimeException {
            collection.add(op);
            for (PhysicalOperator o : op) {
                o.accept(this, collection);
            }
            return null;
        }
    }
}

