/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeSchemaHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(DescribeSchemaHandler.class);
    private static final ObjectMapper mapper = JacksonUtils.createObjectMapper(new JsonFactory().setCharacterEscapes(new CharacterEscapes(){

        public int[] getEscapeCodesForAscii() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[92] = 0;
            return esc;
        }

        public SerializableString getEscapeSequence(int i) {
            return null;
        }
    })).enable(SerializationFeature.INDENT_OUTPUT);

    public DescribeSchemaHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        StoragePlugin storagePlugin;
        SqlIdentifier schema = DescribeSchemaHandler.unwrap(sqlNode, SqlDescribeSchema.class).getSchema();
        SchemaPlus schemaPlus = SchemaUtilities.findSchema(this.config.getConverter().getDefaultSchema(), schema.names);
        if (schemaPlus == null) {
            throw UserException.validationError().message("Invalid schema name [%s]", Joiner.on(".").join(schema.names)).build(logger);
        }
        AbstractSchema drillSchema = SchemaUtilities.unwrapAsDrillSchemaInstance(schemaPlus);
        try {
            storagePlugin = this.context.getStorage().getPlugin(drillSchema.getSchemaPath().get(0));
            if (storagePlugin == null) {
                throw new DrillRuntimeException(String.format("Unable to find storage plugin with the following name [%s].", drillSchema.getSchemaPath().get(0)));
            }
        }
        catch (StoragePluginRegistry.PluginException e) {
            throw new DrillRuntimeException("Failure while retrieving storage plugin", e);
        }
        try {
            Map configMap = (Map)mapper.convertValue((Object)storagePlugin.getConfig(), Map.class);
            if (storagePlugin instanceof FileSystemPlugin) {
                this.transformWorkspaces(drillSchema.getSchemaPath(), configMap);
            }
            String properties = mapper.writeValueAsString((Object)configMap);
            return DirectPlan.createDirectPlan(this.context, new DescribeSchemaResult(drillSchema.getFullSchemaName(), properties));
        }
        catch (JsonProcessingException e) {
            throw new DrillRuntimeException("Error while trying to convert storage config to json string", e);
        }
    }

    private void transformWorkspaces(List<String> names, Map configMap) {
        Object workspaces = configMap.remove("workspaces");
        if (workspaces != null) {
            Map map = (Map)workspaces;
            String key = names.size() > 1 ? names.get(1) : "default";
            Object workspace = map.get(key);
            if (workspace != null) {
                Map workspaceMap = (Map)map.get(key);
                configMap.putAll(workspaceMap);
            } else if ("default".equals(key)) {
                configMap.putAll((Map)mapper.convertValue((Object)WorkspaceConfig.DEFAULT, Map.class));
            }
        }
    }

    public static class DescribeSchemaResult {
        public String schema;
        public String properties;

        public DescribeSchemaResult(String schema, String properties) {
            this.schema = schema;
            this.properties = properties;
        }
    }
}

