/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.SqlSelectBuilder;
import org.apache.drill.exec.planner.sql.conversion.SqlConverter;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.DrillSqlDescribeTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeTableHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(DescribeTableHandler.class);

    public DescribeTableHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws ForemanSetupException {
        DrillSqlDescribeTable node = DescribeTableHandler.unwrap(sqlNode, DrillSqlDescribeTable.class);
        try {
            List<SqlNode> selectList = Arrays.asList(new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO), new SqlIdentifier("DATA_TYPE", SqlParserPos.ZERO), new SqlIdentifier("IS_NULLABLE", SqlParserPos.ZERO));
            SqlIdentifier fromClause = new SqlIdentifier(Arrays.asList("information_schema", InfoSchemaTableType.COLUMNS.name()), SqlParserPos.ZERO);
            SchemaPlus defaultSchema = this.config.getConverter().getDefaultSchema();
            List schemaPathGivenInCmd = Util.skipLast((List)node.getTable().names);
            SchemaPlus schema = SchemaUtilities.findSchema(defaultSchema, schemaPathGivenInCmd);
            if (schema == null) {
                SchemaUtilities.throwSchemaNotFoundException(defaultSchema, SchemaUtilities.getSchemaPath(schemaPathGivenInCmd));
            }
            if (SchemaUtilities.isRootSchema(schema)) {
                throw UserException.validationError().message("No schema selected.", new Object[0]).build(logger);
            }
            AbstractSchema drillSchema = SchemaUtilities.unwrapAsDrillSchemaInstance(schema);
            String schemaPath = drillSchema.getFullSchemaName();
            String tableName = (String)Util.last((List)node.getTable().names);
            if (schema.getTable(tableName) == null) {
                throw UserException.validationError().message("Unknown table [%s] in schema [%s]", tableName, schemaPath).build(logger);
            }
            SqlNode schemaCondition = null;
            if (!SchemaUtilities.isRootSchema(schema)) {
                schemaCondition = DrillParserUtil.createCondition((SqlNode)new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO), (SqlOperator)SqlStdOperatorTable.EQUALS, (SqlNode)SqlLiteral.createCharString((String)schemaPath, (String)Util.getDefaultCharset().name(), (SqlParserPos)SqlParserPos.ZERO));
            }
            SqlIdentifier tableNameColumn = new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO);
            if (!drillSchema.areTableNamesCaseSensitive()) {
                tableNameColumn = SqlStdOperatorTable.LOWER.createCall(SqlParserPos.ZERO, new SqlNode[]{tableNameColumn});
                tableName = tableName.toLowerCase();
            }
            SqlNode where = DrillParserUtil.createCondition((SqlNode)tableNameColumn, (SqlOperator)SqlStdOperatorTable.EQUALS, (SqlNode)SqlLiteral.createCharString((String)tableName, (String)Util.getDefaultCharset().name(), (SqlParserPos)SqlParserPos.ZERO));
            where = DrillParserUtil.createCondition(schemaCondition, (SqlOperator)SqlStdOperatorTable.AND, where);
            SqlNode columnFilter = null;
            if (node.getColumn() != null) {
                columnFilter = DrillParserUtil.createCondition((SqlNode)SqlStdOperatorTable.LOWER.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO)}), (SqlOperator)SqlStdOperatorTable.EQUALS, (SqlNode)SqlLiteral.createCharString((String)node.getColumn().toString().toLowerCase(), (String)Util.getDefaultCharset().name(), (SqlParserPos)SqlParserPos.ZERO));
            } else if (node.getColumnQualifier() != null) {
                SqlNode columnQualifier = node.getColumnQualifier();
                SqlIdentifier column = new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO);
                if (columnQualifier instanceof SqlCharStringLiteral) {
                    NlsString conditionString = ((SqlCharStringLiteral)columnQualifier).getNlsString();
                    columnQualifier = SqlCharStringLiteral.createCharString((String)conditionString.getValue().toLowerCase(), (String)conditionString.getCharsetName(), (SqlParserPos)columnQualifier.getParserPosition());
                    column = SqlStdOperatorTable.LOWER.createCall(SqlParserPos.ZERO, new SqlNode[]{column});
                }
                columnFilter = DrillParserUtil.createCondition((SqlNode)column, (SqlOperator)SqlStdOperatorTable.LIKE, columnQualifier);
            }
            where = DrillParserUtil.createCondition(where, (SqlOperator)SqlStdOperatorTable.AND, columnFilter);
            return new SqlSelectBuilder().parserPosition(SqlParserPos.ZERO).selectList(new SqlNodeList(selectList, SqlParserPos.ZERO)).from((SqlNode)fromClause).where(where).build();
        }
        catch (Exception ex) {
            throw UserException.planError(ex).message("Error while rewriting DESCRIBE query: %d", ex.getMessage()).build(logger);
        }
    }

    @Override
    protected Pair<SqlNode, RelDataType> validateNode(SqlNode sqlNode) throws ValidationException, RelConversionException, ForemanSetupException {
        SqlConverter converter = this.config.getConverter();
        converter.useRootSchemaAsDefault(true);
        Pair<SqlNode, RelDataType> sqlNodeRelDataTypePair = super.validateNode(sqlNode);
        converter.useRootSchemaAsDefault(false);
        return sqlNodeRelDataTypePair;
    }
}

