/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.Util;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillTableInfo {
    private static final Logger logger = LoggerFactory.getLogger(DrillTableInfo.class);
    private final DrillTable drillTable;
    private final String tableName;
    private final List<String> schemaPath;

    private DrillTableInfo(DrillTable drillTable, List<String> schemaPath, String tableName) {
        this.drillTable = drillTable;
        this.tableName = tableName;
        this.schemaPath = schemaPath;
    }

    public DrillTable drillTable() {
        return this.drillTable;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<String> schemaPath() {
        return this.schemaPath;
    }

    public static DrillTableInfo getTableInfoHolder(SqlNode tableRef, SqlHandlerConfig config) {
        switch (tableRef.getKind()) {
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)config.getConverter().validate(tableRef);
                assert (call.getOperandList().size() == 1);
                SqlOperator operator = ((SqlCall)call.operand(0)).getOperator();
                assert (operator instanceof SqlUserDefinedTableMacro);
                SqlUserDefinedTableMacro tableMacro = (SqlUserDefinedTableMacro)operator;
                SqlIdentifier tableIdentifier = tableMacro.getSqlIdentifier();
                AbstractSchema drillSchema = SchemaUtilities.resolveToDrillSchema(config.getConverter().getDefaultSchema(), SchemaUtilities.getSchemaPath(tableIdentifier));
                DrillTable table = (DrillTable)tableMacro.getTable((SqlOperatorBinding)new SqlCallBinding(config.getConverter().getValidator(), null, (SqlCall)call.operand(0)));
                return new DrillTableInfo(table, drillSchema.getSchemaPath(), (String)Util.last((List)tableIdentifier.names));
            }
            case IDENTIFIER: {
                SqlIdentifier tableIdentifier = (SqlIdentifier)tableRef;
                AbstractSchema drillSchema = SchemaUtilities.resolveToDrillSchema(config.getConverter().getDefaultSchema(), SchemaUtilities.getSchemaPath(tableIdentifier));
                String tableName = (String)Util.last((List)tableIdentifier.names);
                DrillTable table = DrillTableInfo.getDrillTable(drillSchema, tableName);
                return new DrillTableInfo(table, drillSchema.getSchemaPath(), tableName);
            }
        }
        throw new UnsupportedOperationException("Unsupported table ref kind: " + tableRef.getKind());
    }

    private static List<SqlNode> prepareTableMacroOperands(SqlCall call) {
        Function<String, SqlNode> convertOperand = paramName -> call.getOperandList().stream().map(sqlNode -> (SqlCall)sqlNode).filter(sqlCall -> ((SqlIdentifier)sqlCall.operand(1)).getSimple().equals(paramName)).peek(sqlCall -> Preconditions.checkState(sqlCall.getKind() == SqlKind.ARGUMENT_ASSIGNMENT)).findFirst().map(sqlCall -> sqlCall.operand(0)).orElse((SqlNode)SqlStdOperatorTable.DEFAULT.createCall(SqlParserPos.ZERO, new SqlNode[0]));
        SqlFunction operator = (SqlFunction)call.getOperator();
        return operator.getParamNames().stream().map(convertOperand).collect(Collectors.toList());
    }

    private static DrillTable getDrillTable(AbstractSchema drillSchema, String tableName) {
        Table tableFromSchema = SqlHandlerUtil.getTableFromSchema(drillSchema, tableName);
        if (tableFromSchema == null) {
            throw UserException.validationError().message("No table with given name [%s] exists in schema [%s]", tableName, drillSchema.getFullSchemaName()).build(logger);
        }
        switch (tableFromSchema.getJdbcTableType()) {
            case TABLE: 
            case SYSTEM_TABLE: {
                if (tableFromSchema instanceof DrillTable) {
                    return (DrillTable)tableFromSchema;
                }
                throw UserException.validationError().message("[%s] table kind is not supported", tableFromSchema.getClass().getSimpleName()).build(logger);
            }
        }
        throw UserException.validationError().message("[%s] object type is not supported", tableFromSchema.getJdbcTableType()).build(logger);
    }
}

