/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.Locale;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.BaseAliasHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlDropAllAliases;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropAllAliasesHandler
extends BaseAliasHandler {
    private static final Logger logger = LoggerFactory.getLogger(DropAllAliasesHandler.class);

    public DropAllAliasesHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException, IOException {
        this.checkAliasesEnabled();
        SqlDropAllAliases node = DropAllAliasesHandler.unwrap(sqlNode, SqlDropAllAliases.class);
        String aliasTarget = ((SqlLiteral)node.getAliasKind()).toValue();
        AliasRegistry aliasRegistry = this.getAliasRegistry(aliasTarget);
        boolean isPublicAlias = ((SqlLiteral)node.getIsPublic()).booleanValue();
        if (isPublicAlias) {
            this.deletePublicAliases(node.getUser(), aliasRegistry);
        } else {
            this.deleteUserAliases(node.getUser(), aliasRegistry);
        }
        return DirectPlan.createDirectPlan(this.context, true, String.format("%s aliases dropped successfully", StringUtils.capitalize((String)aliasTarget.toLowerCase(Locale.ROOT))));
    }

    private void deleteUserAliases(SqlNode user, AliasRegistry aliasRegistry) {
        if (!this.context.isImpersonationEnabled()) {
            throw UserException.validationError().message("Cannot drop user aliases when user impersonation is disabled", new Object[0]).build(logger);
        }
        String userName = this.resolveUserName(user);
        aliasRegistry.deleteUserAliases(userName);
    }

    private void deletePublicAliases(SqlNode user, AliasRegistry aliasRegistry) {
        if (user != null) {
            throw UserException.validationError().message("Cannot drop public aliases for specific user", new Object[0]).build(logger);
        }
        this.checkAdminPrivileges(this.context.getOptions());
        aliasRegistry.deletePublicAliases();
    }
}

