/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.VersionMismatchException;
import org.apache.drill.exec.expr.fn.registry.RemoteFunctionRegistry;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlDropFunction;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;
import org.apache.drill.exec.util.JarUtil;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropFunctionHandler
extends DefaultSqlHandler {
    private static Logger logger = LoggerFactory.getLogger(DropFunctionHandler.class);

    public DropFunctionHandler(SqlHandlerConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException, IOException {
        if (!this.context.getOption((String)"exec.udf.enable_dynamic_support").bool_val.booleanValue()) {
            throw UserException.validationError().message("Dynamic UDFs support is disabled.", new Object[0]).build(logger);
        }
        SqlDropFunction node = DropFunctionHandler.unwrap(sqlNode, SqlDropFunction.class);
        String jarName = ((SqlCharStringLiteral)node.getJar()).toValue();
        RemoteFunctionRegistry remoteFunctionRegistry = this.context.getRemoteFunctionRegistry();
        boolean inProgress = false;
        try {
            String action = remoteFunctionRegistry.addToJars(jarName, RemoteFunctionRegistry.Action.UNREGISTRATION);
            inProgress = action == null;
            if (!inProgress) {
                PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, false, String.format("Jar with %s name is used. Action: %s", jarName, action));
                return physicalPlan;
            }
            UserBitShared.Jar deletedJar = this.unregister(jarName, remoteFunctionRegistry);
            if (deletedJar == null) {
                PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, false, String.format("Jar %s is not registered in remote registry", jarName));
                return physicalPlan;
            }
            remoteFunctionRegistry.submitForUnregistration(jarName);
            this.removeJarFromArea(jarName, remoteFunctionRegistry.getFs(), remoteFunctionRegistry.getRegistryArea());
            this.removeJarFromArea(JarUtil.getSourceName(jarName), remoteFunctionRegistry.getFs(), remoteFunctionRegistry.getRegistryArea());
            PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, true, String.format("The following UDFs in jar %s have been unregistered:\n%s", jarName, deletedJar.getFunctionSignatureList()));
            return physicalPlan;
        }
        catch (Exception e) {
            logger.error("Error during UDF unregistration", (Throwable)e);
            PhysicalPlan physicalPlan = DirectPlan.createDirectPlan(this.context, false, e.getMessage());
            return physicalPlan;
        }
        finally {
            if (inProgress) {
                remoteFunctionRegistry.finishUnregistration(jarName);
                remoteFunctionRegistry.removeFromJars(jarName);
            }
        }
    }

    private UserBitShared.Jar unregister(String jarName, RemoteFunctionRegistry remoteFunctionRegistry) {
        for (int retryAttempts = remoteFunctionRegistry.getRetryAttempts(); retryAttempts >= 0; --retryAttempts) {
            DataChangeVersion version = new DataChangeVersion();
            UserBitShared.Registry registry = remoteFunctionRegistry.getRegistry(version);
            UserBitShared.Jar jarToBeDeleted = null;
            ArrayList<UserBitShared.Jar> jars = Lists.newArrayList();
            for (UserBitShared.Jar j : registry.getJarList()) {
                if (j.getName().equals(jarName)) {
                    jarToBeDeleted = j;
                    continue;
                }
                jars.add(j);
            }
            if (jarToBeDeleted == null) {
                return null;
            }
            UserBitShared.Registry updatedRegistry = UserBitShared.Registry.newBuilder().addAllJar(jars).build();
            try {
                remoteFunctionRegistry.updateRegistry(updatedRegistry, version);
                return jarToBeDeleted;
            }
            catch (VersionMismatchException ex) {
                logger.debug("Failed to update function registry during unregistration, version mismatch was detected.", (Throwable)ex);
                continue;
            }
        }
        throw new DrillRuntimeException("Failed to update remote function registry. Exceeded retry attempts limit.");
    }

    private void removeJarFromArea(String jarName, FileSystem fs, Path area) {
        try {
            fs.delete(new Path(area, jarName), false);
        }
        catch (IOException e) {
            logger.error("Error removing jar {} from area {}", (Object)jarName, (Object)area.toUri().getPath());
        }
    }
}

