/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.planner.common.DrillAggregateRelBase;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.common.DrillSetOpRel;
import org.apache.drill.exec.planner.logical.DrillDirectScanRel;
import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.direct.DirectGroupScan;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

public class FindLimit0Visitor
extends RelShuttleImpl {
    private static final ImmutableSet<SqlTypeName> TYPES = ((ImmutableSet.Builder)ImmutableSet.builder().add(new SqlTypeName[]{SqlTypeName.INTEGER, SqlTypeName.BIGINT, SqlTypeName.FLOAT, SqlTypeName.DOUBLE, SqlTypeName.VARCHAR, SqlTypeName.BOOLEAN, SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIMESTAMP, SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_SECOND, SqlTypeName.CHAR, SqlTypeName.DECIMAL})).build();
    private static final Set<String> unsupportedFunctions = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("KVGEN")).add("MAPPIFY")).add("FLATTEN")).add("CONVERT_FROMJSON")).add("CONVERT_TOJSON")).add("CONVERT_TOSIMPLEJSON")).add("CONVERT_TOEXTENDEDJSON")).build();
    private boolean contains = false;

    private FindLimit0Visitor() {
    }

    public static DrillRel getDirectScanRelIfFullySchemaed(RelNode rel) {
        List fieldList = rel.getRowType().getFieldList();
        ArrayList<TypeProtos.MajorType> columnTypes = new ArrayList<TypeProtos.MajorType>();
        for (RelDataTypeField field : fieldList) {
            SqlTypeName sqlTypeName = field.getType().getSqlTypeName();
            if (!TYPES.contains(sqlTypeName)) {
                return null;
            }
            TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMode(field.getType().isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED).setMinorType(TypeInferenceUtils.getDrillTypeFromCalciteType(sqlTypeName));
            if (sqlTypeName == SqlTypeName.DECIMAL) {
                builder.setScale(field.getType().getScale());
                builder.setPrecision(field.getType().getPrecision());
            } else if (TypeInferenceUtils.isScalarStringType(sqlTypeName)) {
                builder.setPrecision(field.getType().getPrecision());
            }
            columnTypes.add(builder.build());
        }
        RelTraitSet traits = rel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
        RelDataTypeReader reader = new RelDataTypeReader(rel.getRowType().getFieldNames(), columnTypes);
        return new DrillDirectScanRel(rel.getCluster(), traits, new DirectGroupScan(reader, ScanStats.ZERO_RECORD_TABLE), rel.getRowType());
    }

    public static boolean containsLimit0(RelNode rel) {
        FindLimit0Visitor visitor = new FindLimit0Visitor();
        rel.accept((RelShuttle)visitor);
        return visitor.isContains();
    }

    public static DrillRel addLimitOnTopOfLeafNodes(DrillRel rel) {
        final Pointer<Boolean> isUnsupported = new Pointer<Boolean>(false);
        final RexShuttle unsupportedFunctionsVisitor = new RexShuttle(){

            public RexNode visitCall(RexCall call) {
                SqlOperator operator = call.getOperator();
                if (FindLimit0Visitor.isUnsupportedScalarFunction(operator)) {
                    isUnsupported.value = true;
                    return call;
                }
                return super.visitCall(call);
            }
        };
        RelShuttleImpl unsupportedOperationsVisitor = new RelShuttleImpl(){

            public RelNode visit(RelNode other) {
                if (other instanceof DrillSetOpRel) {
                    isUnsupported.value = true;
                    return other;
                }
                if (other instanceof DrillProjectRelBase) {
                    if (!((Boolean)isUnsupported.value).booleanValue()) {
                        other.accept(unsupportedFunctionsVisitor);
                    }
                    if (((Boolean)isUnsupported.value).booleanValue()) {
                        return other;
                    }
                }
                return super.visit(other);
            }
        };
        rel.accept((RelShuttle)unsupportedOperationsVisitor);
        if (((Boolean)isUnsupported.value).booleanValue()) {
            return rel;
        }
        RelShuttleImpl addLimitOnScanVisitor = new RelShuttleImpl(){

            private RelNode addLimitAsParent(RelNode node) {
                RexBuilder builder = node.getCluster().getRexBuilder();
                RexLiteral offset = builder.makeExactLiteral(BigDecimal.ZERO);
                RexLiteral fetch = builder.makeExactLiteral(BigDecimal.ZERO);
                return new DrillLimitRel(node.getCluster(), node.getTraitSet(), node, (RexNode)offset, (RexNode)fetch);
            }

            public RelNode visit(LogicalValues values) {
                return this.addLimitAsParent((RelNode)values);
            }

            public RelNode visit(TableScan scan) {
                return this.addLimitAsParent((RelNode)scan);
            }

            public RelNode visit(RelNode other) {
                if (other.getInputs().isEmpty()) {
                    return this.addLimitAsParent(other);
                }
                return super.visit(other);
            }
        };
        return (DrillRel)rel.accept((RelShuttle)addLimitOnScanVisitor);
    }

    private static boolean isUnsupportedScalarFunction(SqlOperator operator) {
        return operator instanceof DrillSqlOperator && unsupportedFunctions.contains(operator.getName().toUpperCase());
    }

    boolean isContains() {
        return this.contains;
    }

    public RelNode visit(LogicalSort sort) {
        if (DrillRelOptUtil.isLimit0(sort.fetch)) {
            this.contains = true;
            return sort;
        }
        return super.visit(sort);
    }

    public RelNode visit(RelNode other) {
        if (other instanceof DrillJoinRelBase || other instanceof DrillAggregateRelBase || other instanceof DrillSetOpRel) {
            return other;
        }
        if (other instanceof DrillLimitRel && DrillRelOptUtil.isLimit0(((DrillLimitRel)other).getFetch())) {
            this.contains = true;
            return other;
        }
        return super.visit(other);
    }

    public RelNode visit(LogicalAggregate aggregate) {
        return aggregate;
    }

    public RelNode visit(LogicalIntersect intersect) {
        return intersect;
    }

    public RelNode visit(LogicalJoin join) {
        return join;
    }

    public RelNode visit(LogicalMinus minus) {
        return minus;
    }

    public RelNode visit(LogicalUnion union) {
        return union;
    }

    @JsonTypeName(value="RelDataTypeRecordReader")
    public static class RelDataTypeReader
    extends AbstractRecordReader {
        public final List<String> columnNames;
        public final List<TypeProtos.MajorType> columnTypes;

        @JsonCreator
        public RelDataTypeReader(@JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<TypeProtos.MajorType> columnTypes) {
            Preconditions.checkArgument(columnNames.size() == columnTypes.size(), "Number of columns and their types should match");
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }

        @Override
        public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                TypeProtos.MajorType type = this.columnTypes.get(i);
                MaterializedField field = MaterializedField.create(this.columnNames.get(i), type);
                Class<? extends ValueVector> vvClass = TypeHelper.getValueVectorClass(type.getMinorType(), type.getMode());
                try {
                    output.addField(field, vvClass);
                    continue;
                }
                catch (SchemaChangeException e) {
                    throw new ExecutionSetupException(e);
                }
            }
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public void close() throws Exception {
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RelDataTypeReader{columnNames=");
            builder.append(this.columnNames).append(", columnTypes=");
            ArrayList<String> columnTypesList = new ArrayList<String>(this.columnTypes.size());
            for (TypeProtos.MajorType columnType : this.columnTypes) {
                columnTypesList.add(columnType.getMinorType().toString() + "-" + columnType.getMode().toString());
            }
            builder.append(columnTypesList);
            builder.append("}");
            return builder.toString();
        }
    }
}

