/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.List;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlDropTableMetadata;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.operate.Delete;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreDropTableMetadataHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreDropTableMetadataHandler.class);

    public MetastoreDropTableMetadataHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        super(config, textPlan);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        if (!this.context.getOptions().getOption(ExecConstants.METASTORE_ENABLED_VALIDATOR)) {
            throw UserException.validationError().message("Running ANALYZE TABLE DROP command when Metastore is disabled (`metastore.enabled` is set to false)", new Object[0]).build(logger);
        }
        SqlDropTableMetadata dropTableMetadata = MetastoreDropTableMetadataHandler.unwrap(sqlNode, SqlDropTableMetadata.class);
        AbstractSchema drillSchema = SchemaUtilities.resolveToDrillSchema(this.config.getConverter().getDefaultSchema(), dropTableMetadata.getSchemaPath());
        List<String> schemaPath = drillSchema.getSchemaPath();
        String pluginName = schemaPath.get(0);
        String workspaceName = Strings.join(schemaPath.subList(1, schemaPath.size()), (String)".");
        TableInfo tableInfo = TableInfo.builder().name(dropTableMetadata.getName()).storagePlugin(pluginName).workspace(workspaceName).build();
        try {
            Tables tables = this.context.getMetastoreRegistry().get().tables();
            MetastoreTableInfo metastoreTableInfo = tables.basicRequests().metastoreTableInfo(tableInfo);
            if (!metastoreTableInfo.isExists()) {
                if (dropTableMetadata.checkMetadataExistence()) {
                    throw UserException.validationError().message("Metadata for table [%s] not found.", dropTableMetadata.getName()).build(logger);
                }
                return DirectPlan.createDirectPlan(this.context, false, String.format("Metadata for table [%s] does not exist.", dropTableMetadata.getName()));
            }
            tables.modify().delete(Delete.builder().metadataType(MetadataType.ALL).filter(tableInfo.toFilter()).build()).execute();
        }
        catch (MetastoreException e) {
            logger.error("Error when dropping metadata for table {}", (Object)dropTableMetadata.getName(), (Object)e);
            return DirectPlan.createDirectPlan(this.context, false, e.getMessage());
        }
        return DirectPlan.createDirectPlan(this.context, true, String.format("Metadata for table [%s] dropped.", dropTableMetadata.getName()));
    }
}

