/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlShowFiles;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.ischema.Records;
import org.apache.drill.exec.util.FileSystemUtil;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFilesHandler
extends DefaultSqlHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShowFilesHandler.class);

    public ShowFilesHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ForemanSetupException {
        WorkspaceSchemaFactory.WorkspaceSchema wsSchema;
        SchemaPlus defaultSchema;
        SchemaPlus drillSchema = defaultSchema = this.config.getConverter().getDefaultSchema();
        SqlShowFiles showFiles = ShowFilesHandler.unwrap(sqlNode, SqlShowFiles.class);
        SqlIdentifier from = showFiles.getDb();
        String fromDir = null;
        if (from != null) {
            drillSchema = SchemaUtilities.findSchema(defaultSchema, from.names);
            if (drillSchema == null) {
                drillSchema = SchemaUtilities.findSchema(defaultSchema, from.names.subList(0, from.names.size() - 1));
                fromDir = (String)from.names.get(from.names.size() - 1);
            }
            if (drillSchema == null) {
                throw UserException.validationError().message("Invalid FROM/IN clause [%s]", from.toString()).build(logger);
            }
        }
        try {
            wsSchema = (WorkspaceSchemaFactory.WorkspaceSchema)((AbstractSchema)drillSchema.unwrap(AbstractSchema.class)).getDefaultSchema();
        }
        catch (ClassCastException e) {
            throw UserException.validationError().message("SHOW FILES is supported in workspace type schema only. Schema [%s] is not a workspace schema.", SchemaUtilities.getSchemaPath(drillSchema)).build(logger);
        }
        Path endPath = fromDir == null ? new Path(wsSchema.getDefaultLocation()) : new Path(wsSchema.getDefaultLocation(), fromDir);
        Path path = new Path(wsSchema.getFS().getUri().toString(), endPath);
        List records = FileSystemUtil.listAllSafe(wsSchema.getFS(), path, false, new PathFilter[0]).stream().map(fileStatus -> new ShowFilesCommandResult(new Records.File(wsSchema.getFullSchemaName(), wsSchema, (FileStatus)fileStatus))).collect(Collectors.toList());
        return DirectPlan.createDirectPlan(this.context.getCurrentEndpoint(), records, ShowFilesCommandResult.class);
    }

    public static class ShowFilesCommandResult {
        public final String name;
        public final boolean isDirectory;
        public final boolean isFile;
        public final long length;
        public final String owner;
        public final String group;
        public final String permissions;
        public final Timestamp accessTime;
        public final Timestamp modificationTime;

        public ShowFilesCommandResult(Records.File fileRecord) {
            this.name = fileRecord.FILE_NAME;
            this.isDirectory = fileRecord.IS_DIRECTORY;
            this.isFile = fileRecord.IS_FILE;
            this.length = fileRecord.LENGTH;
            this.owner = fileRecord.OWNER;
            this.group = fileRecord.GROUP;
            this.permissions = fileRecord.PERMISSION;
            this.accessTime = fileRecord.ACCESS_TIME;
            this.modificationTime = fileRecord.MODIFICATION_TIME;
        }
    }
}

