/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.tools.RuleSet;
import org.apache.drill.common.util.function.CheckedSupplier;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.conversion.SqlConverter;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.StoragePluginRegistry;

public class SqlHandlerConfig {
    private final QueryContext context;
    private final SqlConverter converter;
    private Map<RelNode, Collection<StoragePlugin>> scannedPluginCache = new HashMap<RelNode, Collection<StoragePlugin>>();

    public SqlHandlerConfig(QueryContext context, SqlConverter converter) {
        this.context = context;
        this.converter = converter;
    }

    public QueryContext getContext() {
        return this.context;
    }

    public RuleSet getRules(PlannerPhase phase, RelNode input) {
        return phase.getRules(this.context, this.getScannedPlugins(input));
    }

    public Collection<StoragePlugin> getScannedPlugins(RelNode input) {
        Collection<StoragePlugin> scannedPlugins = this.scannedPluginCache.get(input);
        if (scannedPlugins == null) {
            PluginsCollector pluginsCollector = new PluginsCollector(this.context.getStorage());
            input.accept((RelShuttle)pluginsCollector);
            scannedPlugins = pluginsCollector.getPlugins();
            this.scannedPluginCache.put(input, scannedPlugins);
        }
        return scannedPlugins;
    }

    public SqlConverter getConverter() {
        return this.converter;
    }

    public static class PluginsCollector
    extends RelShuttleImpl {
        private final TreeSet<StoragePlugin> plugins = new TreeSet<StoragePlugin>(Comparator.comparing(StoragePlugin::getName));
        private final StoragePluginRegistry storagePlugins;

        public PluginsCollector(StoragePluginRegistry storagePlugins) {
            this.storagePlugins = storagePlugins;
        }

        public RelNode visit(TableScan scan) {
            this.collectPlugins((RelNode)scan);
            return scan;
        }

        public RelNode visit(LogicalTableModify modify) {
            this.collectPlugins((RelNode)modify);
            return this.visitChildren((RelNode)modify);
        }

        public RelNode visit(RelNode other) {
            if (other instanceof TableModify) {
                this.collectPlugins(other);
            }
            return super.visit(other);
        }

        private void collectPlugins(RelNode relNode) {
            String pluginName = SchemaUtilities.getSchemaPathAsList((String)relNode.getTable().getQualifiedName().iterator().next()).iterator().next();
            CheckedSupplier pluginsProvider = () -> this.storagePlugins.getPlugin(pluginName);
            StoragePlugin storagePlugin = Optional.ofNullable(DrillRelOptUtil.getDrillTable(relNode)).map(DrillTable::getPlugin).orElseGet(pluginsProvider);
            this.plugins.add(storagePlugin);
        }

        public Collection<StoragePlugin> getPlugins() {
            return this.plugins;
        }
    }
}

