/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.parser.SqlUseSchema;
import org.apache.drill.exec.work.foreman.ForemanSetupException;

public class UseSchemaHandler
extends AbstractSqlHandler {
    QueryContext context;

    public UseSchemaHandler(QueryContext context) {
        this.context = context;
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        SqlUseSchema useSchema = UseSchemaHandler.unwrap(sqlNode, SqlUseSchema.class);
        String newDefaultSchemaPath = useSchema.getSchema();
        this.context.getSession().setDefaultSchemaPath(newDefaultSchemaPath, this.context.getNewDefaultSchema());
        return DirectPlan.createDirectPlan(this.context, true, String.format("Default schema changed to [%s]", this.context.getSession().getDefaultSchemaPath()));
    }
}

