/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillCompoundIdentifier
extends SqlIdentifier {
    private static final Function<String, String> STAR_TO_EMPTY = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.equals("*") ? "" : s;
        }
    };
    private final List<IdentifierHolder> ids;

    private static List<String> getNames(List<IdentifierHolder> identifiers) {
        ArrayList<String> names = Lists.newArrayListWithCapacity(identifiers.size());
        for (IdentifierHolder h : identifiers) {
            names.add(h.value);
        }
        return names;
    }

    public DrillCompoundIdentifier(List<IdentifierHolder> identifiers) {
        super(DrillCompoundIdentifier.getNames(identifiers), identifiers.get((int)0).parserPos);
        this.ids = identifiers;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SqlNode getAsSqlNode(boolean allowNoTableRefCompoundIdentifier) {
        SqlIdentifier node;
        int startIndex;
        if (this.ids.size() == 1) {
            return new SqlIdentifier(Collections.singletonList(this.ids.get((int)0).value), this.ids.get((int)0).parserPos);
        }
        if (this.ids.get(1).isArray()) {
            startIndex = 1;
            node = new SqlIdentifier(ImmutableList.of(this.ids.get((int)0).value), null, this.ids.get((int)0).parserPos, ImmutableList.of(this.ids.get((int)0).parserPos));
        } else if (allowNoTableRefCompoundIdentifier) {
            startIndex = 1;
            node = new SqlIdentifier(ImmutableList.of(STAR_TO_EMPTY.apply(this.ids.get((int)0).value)), null, this.ids.get((int)0).parserPos, ImmutableList.of(this.ids.get((int)0).parserPos));
        } else {
            startIndex = 2;
            node = new SqlIdentifier(ImmutableList.of(this.ids.get((int)0).value, STAR_TO_EMPTY.apply(this.ids.get((int)1).value)), null, this.ids.get((int)0).parserPos, ImmutableList.of(this.ids.get((int)0).parserPos, this.ids.get((int)1).parserPos));
        }
        for (int i = startIndex; i < this.ids.size(); ++i) {
            node = this.ids.get(i).getNode((SqlNode)node);
        }
        return node;
    }

    public SqlNode getAsCompoundIdentifier() {
        ArrayList<String> names = Lists.newArrayListWithCapacity(this.ids.size());
        ArrayList<SqlParserPos> pos = Lists.newArrayListWithCapacity(this.ids.size());
        for (IdentifierHolder holder : this.ids) {
            names.add(holder.value);
            pos.add(holder.parserPos);
        }
        return new SqlIdentifier(names, null, (SqlParserPos)pos.get(0), pos);
    }

    private static class IdentifierHolder {
        String value;
        SqlParserPos parserPos;
        boolean isArray;

        public IdentifierHolder(String value, SqlParserPos parserPos, boolean isArray) {
            this.isArray = isArray;
            this.value = value;
            this.parserPos = parserPos;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public SqlNode getNode(SqlNode node) {
            Object literal = this.isArray ? SqlLiteral.createExactNumeric((String)this.value, (SqlParserPos)this.parserPos) : SqlLiteral.createCharString((String)this.value, (SqlParserPos)this.parserPos);
            return new SqlBasicCall(SqlStdOperatorTable.ITEM, new SqlNode[]{node, literal}, this.parserPos);
        }
    }

    public static class Builder {
        private List<IdentifierHolder> identifiers = Lists.newArrayList();

        public DrillCompoundIdentifier build() {
            return new DrillCompoundIdentifier(this.identifiers);
        }

        public void addString(String name, SqlParserPos pos) {
            this.identifiers.add(new IdentifierHolder(name, pos, false));
        }

        public void addIndex(int index, SqlParserPos pos) {
            this.identifiers.add(new IdentifierHolder(Integer.toString(index), pos, true));
        }
    }
}

