/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.AnalyzeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SqlAnalyzeTable
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ANALYZE_TABLE", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            Preconditions.checkArgument(operands.length == 4, "SqlAnalyzeTable.createCall() has to get 4 operands!");
            return new SqlAnalyzeTable(pos, operands[0], (SqlLiteral)operands[1], (SqlNodeList)operands[2], (SqlNumericLiteral)operands[3]);
        }
    };
    private final SqlNode tableRef;
    private final SqlLiteral estimate;
    private final SqlNodeList fieldList;
    private final SqlNumericLiteral samplePercent;

    public SqlAnalyzeTable(SqlParserPos pos, SqlNode tableRef, SqlLiteral estimate, SqlNodeList fieldList, SqlNumericLiteral samplePercent) {
        super(pos);
        this.tableRef = tableRef;
        this.estimate = estimate;
        this.fieldList = fieldList;
        this.samplePercent = samplePercent;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> operands = Lists.newArrayListWithCapacity(4);
        operands.add(this.tableRef);
        operands.add((SqlNode)this.estimate);
        operands.add((SqlNode)this.fieldList);
        operands.add((SqlNode)this.samplePercent);
        return operands;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE");
        writer.keyword("TABLE");
        this.tableRef.unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.estimate.booleanValue() ? "ESTIMATE" : "COMPUTE");
        writer.keyword("STATISTICS");
        if (this.fieldList != null && this.fieldList.size() > 0) {
            writer.keyword("(");
            this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
            for (int i = 1; i < this.fieldList.size(); ++i) {
                writer.keyword(",");
                this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
        writer.keyword("SAMPLE");
        this.samplePercent.unparse(writer, leftPrec, rightPrec);
        writer.keyword("PERCENT");
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        return new AnalyzeTableHandler(config, textPlan);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return this.getSqlHandler(config, null);
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public List<String> getFieldNames() {
        if (this.fieldList == null) {
            return ImmutableList.of();
        }
        ArrayList<String> columnNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            columnNames.add(node.toString());
        }
        return columnNames;
    }

    public SqlNodeList getFieldList() {
        return this.fieldList;
    }

    public boolean getEstimate() {
        return this.estimate.booleanValue();
    }

    public int getSamplePercent() {
        return this.samplePercent.intValue(true);
    }
}

