/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.handlers.ViewHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.planner.sql.parser.SqlCreateType;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SqlCreateView
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_VIEW", SqlKind.CREATE_VIEW){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlCreateView(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], operands[2], (SqlLiteral)operands[3]);
        }
    };
    private SqlIdentifier viewName;
    private SqlNodeList fieldList;
    private SqlNode query;
    private SqlLiteral createType;

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, SqlLiteral createType) {
        super(pos);
        this.viewName = viewName;
        this.query = query;
        this.fieldList = fieldList;
        this.createType = createType;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add((SqlNode)this.viewName);
        ops.add((SqlNode)this.fieldList);
        ops.add(this.query);
        ops.add((SqlNode)this.createType);
        return ops;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        switch (SqlCreateType.valueOf(this.createType.toValue())) {
            case SIMPLE: {
                writer.keyword("VIEW");
                break;
            }
            case OR_REPLACE: {
                writer.keyword("OR");
                writer.keyword("REPLACE");
                writer.keyword("VIEW");
                break;
            }
            case IF_NOT_EXISTS: {
                writer.keyword("VIEW");
                writer.keyword("IF");
                writer.keyword("NOT");
                writer.keyword("EXISTS");
            }
        }
        this.viewName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList.size() > 0) {
            SqlHandlerUtil.unparseSqlNodeList(writer, leftPrec, rightPrec, this.fieldList);
        }
        writer.keyword("AS");
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new ViewHandler.CreateView(config);
    }

    public List<String> getSchemaPath() {
        return SchemaUtilities.getSchemaPath(this.viewName);
    }

    public String getName() {
        if (this.viewName.isSimple()) {
            return this.viewName.getSimple();
        }
        return (String)this.viewName.names.get(this.viewName.names.size() - 1);
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            fieldNames.add(node.toString());
        }
        return fieldNames;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public SqlCreateType getSqlCreateType() {
        return SqlCreateType.valueOf(this.createType.toValue());
    }
}

