/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DropAliasHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;

public class SqlDropAlias
extends DrillSqlCall {
    private final SqlNode isPublic;
    private final SqlNode ifExists;
    private final SqlIdentifier alias;
    private final SqlNode aliasKind;
    private final SqlNode user;
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_ALIAS", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return SqlDropAlias.builder().pos(pos).alias((SqlIdentifier)operands[0]).aliasKind(operands[1]).ifExists(operands[2]).isPublic(operands[3]).user(operands[4]).build();
        }
    };

    private SqlDropAlias(SqlDropAliasBuilder builder) {
        super(builder.pos);
        this.alias = builder.alias;
        this.ifExists = builder.ifExists;
        this.isPublic = builder.isPublic;
        this.aliasKind = builder.aliasKind;
        this.user = builder.user;
    }

    public static SqlDropAliasBuilder builder() {
        return new SqlDropAliasBuilder();
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> opList = new ArrayList<SqlNode>();
        opList.add((SqlNode)this.alias);
        opList.add(this.aliasKind);
        opList.add(this.ifExists);
        opList.add(this.isPublic);
        opList.add(this.user);
        return opList;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (((SqlLiteral)this.isPublic).booleanValue()) {
            writer.keyword("PUBLIC");
        }
        writer.keyword("ALIAS");
        if (((SqlLiteral)this.ifExists).booleanValue()) {
            writer.keyword("IF");
            writer.keyword("EXISTS");
        }
        this.alias.unparse(writer, leftPrec, rightPrec);
        writer.keyword("FOR");
        writer.keyword(((SqlLiteral)this.aliasKind).toValue());
        if (this.user != null) {
            writer.keyword("AS");
            writer.keyword("USER");
            this.user.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new DropAliasHandler(config);
    }

    public SqlNode getIsPublic() {
        return this.isPublic;
    }

    public SqlNode getIfExists() {
        return this.ifExists;
    }

    public SqlIdentifier getAlias() {
        return this.alias;
    }

    public SqlNode getAliasKind() {
        return this.aliasKind;
    }

    public SqlNode getUser() {
        return this.user;
    }

    public static class SqlDropAliasBuilder {
        private SqlParserPos pos;
        private SqlIdentifier alias;
        private SqlNode ifExists;
        private SqlNode isPublic;
        private SqlNode aliasKind;
        private SqlNode user;

        public SqlDropAliasBuilder pos(SqlParserPos pos) {
            this.pos = pos;
            return this;
        }

        public SqlDropAliasBuilder alias(SqlIdentifier alias) {
            this.alias = alias;
            return this;
        }

        public SqlDropAliasBuilder ifExists(SqlNode ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        public SqlDropAliasBuilder isPublic(SqlNode isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public SqlDropAliasBuilder aliasKind(SqlNode aliasKind) {
            this.aliasKind = aliasKind;
            return this;
        }

        public SqlDropAliasBuilder user(SqlNode user) {
            this.user = user;
            return this;
        }

        public SqlDropAlias build() {
            return new SqlDropAlias(this);
        }
    }
}

