/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DropTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class SqlDropTable
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_TABLE", SqlKind.DROP_TABLE){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDropTable(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1]);
        }
    };
    private final SqlIdentifier tableName;
    private final boolean tableExistenceCheck;

    public SqlDropTable(SqlParserPos pos, SqlIdentifier tableName, SqlLiteral tableExistenceCheck) {
        this(pos, tableName, tableExistenceCheck.booleanValue());
    }

    public SqlDropTable(SqlParserPos pos, SqlIdentifier tableName, boolean tableExistenceCheck) {
        super(pos);
        this.tableName = tableName;
        this.tableExistenceCheck = tableExistenceCheck;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ImmutableList<SqlLiteral> ops = ImmutableList.of(this.tableName, SqlLiteral.createBoolean((boolean)this.tableExistenceCheck, (SqlParserPos)SqlParserPos.ZERO));
        return ops;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("TABLE");
        if (this.tableExistenceCheck) {
            writer.keyword("IF");
            writer.keyword("EXISTS");
        }
        this.tableName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new DropTableHandler(config);
    }

    public List<String> getSchema() {
        return SchemaUtilities.getSchemaPath(this.tableName);
    }

    public String getName() {
        if (this.tableName.isSimple()) {
            return this.tableName.getSimple();
        }
        return (String)this.tableName.names.get(this.tableName.names.size() - 1);
    }

    public SqlIdentifier getTableIdentifier() {
        return this.tableName;
    }

    public boolean checkTableExistence() {
        return this.tableExistenceCheck;
    }
}

