/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.ViewHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class SqlDropView
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_VIEW", SqlKind.DROP_VIEW){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDropView(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1]);
        }
    };
    private SqlIdentifier viewName;
    private boolean viewExistenceCheck;

    public SqlDropView(SqlParserPos pos, SqlIdentifier viewName, SqlLiteral viewExistenceCheck) {
        this(pos, viewName, viewExistenceCheck.booleanValue());
    }

    public SqlDropView(SqlParserPos pos, SqlIdentifier viewName, boolean viewExistenceCheck) {
        super(pos);
        this.viewName = viewName;
        this.viewExistenceCheck = viewExistenceCheck;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ImmutableList<SqlLiteral> ops = ImmutableList.of(this.viewName, SqlLiteral.createBoolean((boolean)this.viewExistenceCheck, (SqlParserPos)SqlParserPos.ZERO));
        return ops;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("VIEW");
        if (this.viewExistenceCheck) {
            writer.keyword("IF");
            writer.keyword("EXISTS");
        }
        this.viewName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new ViewHandler.DropView(config);
    }

    public List<String> getSchemaPath() {
        return SchemaUtilities.getSchemaPath(this.viewName);
    }

    public String getName() {
        if (this.viewName.isSimple()) {
            return this.viewName.getSimple();
        }
        return (String)this.viewName.names.get(this.viewName.names.size() - 1);
    }

    public boolean checkViewExistence() {
        return this.viewExistenceCheck;
    }
}

