/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.MetastoreAnalyzeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.util.Pointer;

public class SqlMetastoreAnalyzeTable
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("METASTORE_ANALYZE_TABLE", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlMetastoreAnalyzeTable(pos, operands[0], (SqlNodeList)operands[1], operands[2], (SqlLiteral)operands[3], (SqlNumericLiteral)operands[4]);
        }
    };
    private final SqlNode tableRef;
    private final SqlNodeList fieldList;
    private final SqlLiteral level;
    private final SqlLiteral estimate;
    private final SqlNumericLiteral samplePercent;

    public SqlMetastoreAnalyzeTable(SqlParserPos pos, SqlNode tableRef, SqlNodeList fieldList, SqlNode level, SqlLiteral estimate, SqlNumericLiteral samplePercent) {
        super(pos);
        this.tableRef = tableRef;
        this.fieldList = fieldList;
        this.level = level != null ? SqlLiteral.unchain((SqlNode)level) : null;
        this.estimate = estimate;
        this.samplePercent = samplePercent;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.tableRef, this.fieldList, this.level, this.estimate, this.samplePercent);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE");
        writer.keyword("TABLE");
        this.tableRef.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList != null) {
            writer.keyword("COLUMNS");
            if (this.fieldList.size() > 0) {
                writer.keyword("(");
                this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
                for (int i = 1; i < this.fieldList.size(); ++i) {
                    writer.keyword(",");
                    this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
                }
                writer.keyword(")");
            } else {
                writer.keyword("NONE");
            }
        }
        writer.keyword("REFRESH");
        writer.keyword("METADATA");
        if (this.level != null) {
            this.level.unparse(writer, leftPrec, rightPrec);
        }
        if (this.estimate != null) {
            writer.keyword(this.estimate.booleanValue() ? "ESTIMATE" : "COMPUTE");
            writer.keyword("STATISTICS");
        }
        if (this.samplePercent != null) {
            writer.keyword("SAMPLE");
            this.samplePercent.unparse(writer, leftPrec, rightPrec);
            writer.keyword("PERCENT");
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        return new MetastoreAnalyzeTableHandler(config, textPlan);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return this.getSqlHandler(config, null);
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public List<SchemaPath> getFieldNames() {
        if (this.fieldList == null) {
            return null;
        }
        return this.fieldList.getList().stream().map(sqlNode -> SchemaPath.parseFromString(sqlNode.toSqlString(null, true).getSql())).collect(Collectors.toList());
    }

    public SqlNodeList getFieldList() {
        return this.fieldList;
    }

    public SqlLiteral getLevel() {
        return this.level;
    }

    public SqlLiteral getEstimate() {
        return this.estimate;
    }

    public SqlNumericLiteral getSamplePercent() {
        return this.samplePercent;
    }
}

