/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.RefreshMetadataHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SqlRefreshMetadata
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("REFRESH_TABLE_METADATA", SqlKind.OTHER_DDL){

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlRefreshMetadata(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1], (SqlNodeList)operands[2]);
        }
    };
    private SqlIdentifier tblName;
    private final SqlLiteral allColumns;
    private final SqlNodeList fieldList;

    public SqlRefreshMetadata(SqlParserPos pos, SqlIdentifier tblName, SqlLiteral allColumns, SqlNodeList fieldList) {
        super(pos);
        this.tblName = tblName;
        this.allColumns = allColumns;
        this.fieldList = fieldList;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add((SqlNode)this.tblName);
        ops.add((SqlNode)this.allColumns);
        ops.add((SqlNode)this.fieldList);
        return ops;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("REFRESH");
        writer.keyword("TABLE");
        writer.keyword("METADATA");
        if (!this.allColumns.booleanValue()) {
            writer.keyword("COLUMNS");
            if (this.fieldList == null) {
                writer.keyword("NONE");
            } else if (this.fieldList.size() > 0) {
                writer.keyword("(");
                this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
                for (int i = 1; i < this.fieldList.size(); ++i) {
                    writer.keyword(",");
                    this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
                }
                writer.keyword(")");
            }
        }
        this.tblName.unparse(writer, leftPrec, rightPrec);
    }

    public String getName() {
        if (this.tblName.isSimple()) {
            return this.tblName.getSimple();
        }
        return (String)this.tblName.names.get(this.tblName.names.size() - 1);
    }

    public List<String> getSchemaPath() {
        return SchemaUtilities.getSchemaPath(this.tblName);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new RefreshMetadataHandler(config);
    }

    public SqlNodeList getFieldList() {
        return this.fieldList;
    }

    public SqlLiteral getAllColumns() {
        return this.allColumns;
    }
}

