/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SchemaHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.planner.sql.parser.SqlCreateType;

public abstract class SqlSchema
extends DrillSqlCall {
    protected final SqlIdentifier table;
    protected final SqlNode path;

    protected SqlSchema(SqlParserPos pos, SqlIdentifier table, SqlNode path) {
        super(pos);
        this.table = table;
        this.path = path;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.table != null) {
            writer.keyword("FOR TABLE");
            this.table.unparse(writer, leftPrec, rightPrec);
        }
        if (this.path != null) {
            writer.keyword("PATH");
            this.path.unparse(writer, leftPrec, rightPrec);
        }
    }

    public boolean hasTable() {
        return this.table != null;
    }

    public SqlIdentifier getTable() {
        return this.table;
    }

    public List<String> getSchemaPath() {
        return this.hasTable() ? SchemaUtilities.getSchemaPath(this.table) : null;
    }

    public String getTableName() {
        if (this.hasTable()) {
            String tableName = this.table.isSimple() ? this.table.getSimple() : (String)this.table.names.get(this.table.names.size() - 1);
            return DrillStringUtils.removeLeadingSlash(tableName);
        }
        return null;
    }

    public String getPath() {
        return this.path == null ? null : (String)this.path.accept((SqlVisitor)LiteralVisitor.INSTANCE);
    }

    protected Map<String, String> getProperties(SqlNodeList properties) {
        if (properties == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 1; i < properties.size(); i += 2) {
            map.put((String)properties.get(i - 1).accept((SqlVisitor)LiteralVisitor.INSTANCE), (String)properties.get(i).accept((SqlVisitor)LiteralVisitor.INSTANCE));
        }
        return map;
    }

    private static class LiteralVisitor
    extends SqlBasicVisitor<String> {
        static final LiteralVisitor INSTANCE = new LiteralVisitor();

        private LiteralVisitor() {
        }

        public String visit(SqlLiteral literal) {
            return literal.toValue();
        }
    }

    public static class Remove
    extends SqlSchema {
        private final SqlNodeList columns;
        private final SqlNodeList properties;
        public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER_SCHEMA_REMOVE", SqlKind.OTHER_DDL){

            public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
                return new Remove(pos, (SqlIdentifier)operands[0], operands[1], (SqlNodeList)operands[2], (SqlNodeList)operands[3]);
            }
        };

        public Remove(SqlParserPos pos, SqlIdentifier table, SqlNode path, SqlNodeList columns, SqlNodeList properties) {
            super(pos, table, path);
            this.columns = columns;
            this.properties = properties;
        }

        public SqlOperator getOperator() {
            return OPERATOR;
        }

        public List<SqlNode> getOperandList() {
            return Arrays.asList(this.table, this.path, this.columns, this.properties);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("ALTER");
            writer.keyword("SCHEMA");
            writer.keyword("REMOVE");
            super.unparse(writer, leftPrec, rightPrec);
            if (this.columns != null) {
                writer.keyword("COLUMNS");
                SqlHandlerUtil.unparseSqlNodeList(writer, leftPrec, rightPrec, this.columns);
            }
            if (this.properties != null) {
                writer.keyword("PROPERTIES");
                SqlHandlerUtil.unparseSqlNodeList(writer, leftPrec, rightPrec, this.properties);
            }
        }

        @Override
        public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
            return new SchemaHandler.Remove(config);
        }

        public List<String> getColumns() {
            if (this.columns == null) {
                return null;
            }
            return this.columns.getList().stream().map(SqlNode::toString).collect(Collectors.toList());
        }

        public boolean hasProperties() {
            return this.properties != null;
        }

        public List<String> getProperties() {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getList().stream().map(property -> (String)property.accept((SqlVisitor)LiteralVisitor.INSTANCE)).collect(Collectors.toList());
        }
    }

    public static class Add
    extends SqlSchema {
        private final SqlLiteral replace;
        private final SqlCharStringLiteral schema;
        private final SqlNodeList properties;
        public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER_SCHEMA_ADD", SqlKind.OTHER_DDL){

            public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
                return new Add(pos, (SqlIdentifier)operands[0], operands[1], (SqlLiteral)operands[2], (SqlCharStringLiteral)operands[3], (SqlNodeList)operands[4]);
            }
        };

        public Add(SqlParserPos pos, SqlIdentifier table, SqlNode path, SqlLiteral replace, SqlCharStringLiteral schema, SqlNodeList properties) {
            super(pos, table, path);
            this.replace = replace;
            this.schema = schema;
            this.properties = properties;
        }

        public SqlOperator getOperator() {
            return OPERATOR;
        }

        public List<SqlNode> getOperandList() {
            return Arrays.asList(this.table, this.path, this.replace, this.schema, this.properties);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("ALTER");
            writer.keyword("SCHEMA");
            writer.keyword("ADD");
            if (this.replace.booleanValue()) {
                writer.keyword("OR");
                writer.keyword("REPLACE");
            }
            super.unparse(writer, leftPrec, rightPrec);
            if (this.schema != null) {
                writer.keyword("COLUMNS");
                writer.literal(this.getSchema());
            }
            if (this.properties != null) {
                writer.keyword("PROPERTIES");
                SqlHandlerUtil.unparseKeyValuePairs(writer, leftPrec, rightPrec, this.properties);
            }
        }

        @Override
        public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
            return new SchemaHandler.Add(config);
        }

        public boolean isReplace() {
            return this.replace.booleanValue();
        }

        public boolean hasSchema() {
            return this.schema != null;
        }

        public String getSchema() {
            return this.hasSchema() ? this.schema.toValue() : null;
        }

        public boolean hasProperties() {
            return this.properties != null;
        }

        public Map<String, String> getProperties() {
            return this.getProperties(this.properties);
        }
    }

    public static class Describe
    extends SqlSchema {
        private final SqlLiteral format;
        public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator(SqlKind.DESCRIBE_SCHEMA.name(), SqlKind.DESCRIBE_SCHEMA){

            public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
                return new Describe(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1]);
            }
        };

        public Describe(SqlParserPos pos, SqlIdentifier table, SqlLiteral format) {
            super(pos, table, null);
            this.format = format;
        }

        public SqlOperator getOperator() {
            return OPERATOR;
        }

        public List<SqlNode> getOperandList() {
            return Arrays.asList(this.table, this.format);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("DESCRIBE");
            writer.keyword("SCHEMA");
            super.unparse(writer, leftPrec, rightPrec);
            writer.keyword("AS");
            writer.keyword(this.getFormat().name());
        }

        public Format getFormat() {
            return Format.valueOf(this.format.toValue());
        }

        public static enum Format {
            JSON,
            STATEMENT;

        }
    }

    public static class Drop
    extends SqlSchema {
        private final SqlLiteral existenceCheck;
        public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_SCHEMA", SqlKind.OTHER_DDL){

            public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
                return new Drop(pos, (SqlIdentifier)operands[0], (SqlLiteral)operands[1]);
            }
        };

        public Drop(SqlParserPos pos, SqlIdentifier table, SqlLiteral existenceCheck) {
            super(pos, table, null);
            this.existenceCheck = existenceCheck;
        }

        public SqlOperator getOperator() {
            return OPERATOR;
        }

        public List<SqlNode> getOperandList() {
            return Arrays.asList(this.table, this.existenceCheck);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("DROP");
            writer.keyword("SCHEMA");
            if (this.ifExists()) {
                writer.keyword("IF");
                writer.keyword("EXISTS");
            }
            super.unparse(writer, leftPrec, rightPrec);
        }

        @Override
        public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
            return new SchemaHandler.Drop(config);
        }

        public boolean ifExists() {
            return this.existenceCheck.booleanValue();
        }
    }

    public static class Create
    extends SqlSchema {
        private final SqlCharStringLiteral schema;
        private final SqlNode load;
        private final SqlNodeList properties;
        private final SqlLiteral createType;
        public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_SCHEMA", SqlKind.OTHER_DDL){

            public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
                return new Create(pos, (SqlCharStringLiteral)operands[0], operands[1], (SqlIdentifier)operands[2], operands[3], (SqlNodeList)operands[4], (SqlLiteral)operands[5]);
            }
        };

        public Create(SqlParserPos pos, SqlCharStringLiteral schema, SqlNode load, SqlIdentifier table, SqlNode path, SqlNodeList properties, SqlLiteral createType) {
            super(pos, table, path);
            this.schema = schema;
            this.load = load;
            this.properties = properties;
            this.createType = createType;
        }

        public SqlOperator getOperator() {
            return OPERATOR;
        }

        public List<SqlNode> getOperandList() {
            return Arrays.asList(this.schema, this.load, this.table, this.path, this.properties, this.createType);
        }

        @Override
        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("CREATE");
            if (SqlCreateType.OR_REPLACE == this.getSqlCreateType()) {
                writer.keyword("OR");
                writer.keyword("REPLACE");
            }
            if (this.schema != null) {
                writer.keyword("SCHEMA");
                writer.literal(this.getSchema());
            }
            if (this.load != null) {
                writer.keyword("LOAD");
                this.load.unparse(writer, leftPrec, rightPrec);
            }
            super.unparse(writer, leftPrec, rightPrec);
            if (this.properties != null) {
                writer.keyword("PROPERTIES");
                SqlHandlerUtil.unparseKeyValuePairs(writer, leftPrec, rightPrec, this.properties);
            }
        }

        @Override
        public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
            return new SchemaHandler.Create(config);
        }

        public boolean hasSchema() {
            return this.schema != null;
        }

        public String getSchema() {
            return this.hasSchema() ? this.schema.toValue() : null;
        }

        public String getLoad() {
            return this.load == null ? null : (String)this.load.accept((SqlVisitor)LiteralVisitor.INSTANCE);
        }

        public Map<String, String> getProperties() {
            return this.getProperties(this.properties);
        }

        public SqlCreateType getSqlCreateType() {
            return SqlCreateType.valueOf(this.createType.toValue());
        }
    }
}

